/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.netezza.datasource.NzDatasource;
import org.netezza.error.NzSQLException;
import org.netezza.internal.GSSCallbackHandler;
import org.netezza.internal.GssAction;
import org.netezza.internal.NzSocket;

public class NzKrb5GSSAuthentication {
    private NzSocket socket;
    private NzDatasource datasource;

    public NzKrb5GSSAuthentication(NzSocket socket, NzDatasource datasource) {
        this.socket = socket;
        this.datasource = datasource;
    }

    public void authenticate() throws SQLException {
        String result = null;
        LoginContext lc = null;
        try {
            if (this.datasource.isClientKrbSSODelegated()) {
                GssAction action = new GssAction(this.socket, this.datasource);
                result = action.startContextEstablishment();
            } else {
                String rawuser = this.datasource.getUser();
                if (rawuser.startsWith("\"") && rawuser.endsWith("\"")) {
                    rawuser = rawuser.substring(1, rawuser.length() - 1);
                }
                lc = new LoginContext(this.datasource.getKrbLoginModuleName(), new GSSCallbackHandler(rawuser, this.datasource.getPassword()));
                lc.login();
                Subject sub = lc.getSubject();
                GssAction action = new GssAction(this.socket, this.datasource);
                result = Subject.doAs(sub, action);
            }
            if (result != null) {
                NzSQLException etothrow = new NzSQLException(result.toString(), "08001", 1114, new Object[0]);
                throw etothrow;
            }
        }
        catch (Exception e) {
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            throw etothrow;
        }
        finally {
            try {
                lc.logout();
            }
            catch (Exception eLE) {}
        }
    }
}

