/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.externaltable;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.netezza.core.Encoding;
import org.netezza.sql.NzConnection;

public class NzUnload {
    private NzConnection connection;
    private FileOutputStream stream = null;
    private String fileName = null;
    private int bufSize = -1;
    private byte[] datablock = null;

    public NzUnload(NzConnection connection) {
        this.connection = connection;
    }

    public void setUpUnload() throws SQLException {
        String method = "setUpUnload";
        this.connection.LOGGER.entry(this.getClass(), method);
        try {
            int clientVersion = this.connection.receiveIntR(2);
            this.connection.LOGGER.debug(this.getClass(), method, "CLIENT VERSION: " + clientVersion);
            int format = this.connection.receiveIntR(2);
            this.connection.LOGGER.debug(this.getClass(), method, "FORMAT: " + format);
            this.bufSize = this.connection.receiveIntR(4);
            this.connection.LOGGER.debug(this.getClass(), method, "BUFFER SIZE: " + this.bufSize);
            this.datablock = new byte[this.bufSize];
            this.connection.receiveIntR(16);
            int length = this.connection.receiveIntR(2);
            byte[] fileNmeBytes = new byte[length];
            this.connection.receiveBytes(fileNmeBytes, 0, length);
            this.fileName = Encoding.UNICODE.decode(fileNmeBytes);
            this.connection.LOGGER.debug(this.getClass(), method, "FILE NAME: " + this.fileName);
            try {
                this.stream = new FileOutputStream(this.fileName, false);
            }
            catch (Exception ex) {
                SQLException etothrow = new SQLException("Error occured while opening file." + ex.toString());
                this.connection.LOGGER.fatal(this.getClass(), method, ex);
                throw etothrow;
            }
            this.connection.sendInt(0, 4);
            this.connection.flush();
            this.connection.LOGGER.exit(this.getClass(), method);
        }
        catch (SQLException sqlex) {
            int errNos = 1;
            this.connection.STATE = (short)4;
            this.connection.sendInt(errNos, 4);
            this.connection.flush();
            throw sqlex;
        }
    }

    public void unload() throws SQLException {
        String method = "unload";
        this.connection.LOGGER.entry(this.getClass(), method);
        int status = -1;
        int numBytes = -1;
        int errNos = -1;
        int len = -1;
        byte[] errorString = null;
        byte[] errorObject = null;
        boolean alldone = false;
        block13: while (!alldone) {
            SQLException etothrow;
            status = this.connection.receiveIntR(4);
            switch (status) {
                case 1: {
                    this.connection.LOGGER.debug(this.getClass(), method, "EXTAB_SOCK_DATA");
                    numBytes = this.connection.receiveIntR(4);
                    if (numBytes > this.bufSize) {
                        this.cleanupUnload("Number of bytes greater than block size.", true);
                    }
                    this.connection.receiveBytes(this.datablock, 0, numBytes);
                    try {
                        this.stream.write(this.datablock, 0, numBytes);
                    }
                    catch (IOException ex) {
                        this.cleanupUnload("Error occured while writing to file.", true);
                    }
                    continue block13;
                }
                case 3: {
                    this.connection.LOGGER.debug(this.getClass(), method, "EXTAB_SOCK_DONE");
                    try {
                        this.stream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    this.datablock = null;
                    alldone = true;
                    continue block13;
                }
                case 2: {
                    this.connection.LOGGER.debug(this.getClass(), method, "EXTAB_SOCK_ERROR");
                    try {
                        this.stream.close();
                        new File(this.fileName).delete();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    errNos = this.connection.receiveIntR(4);
                    len = this.connection.receiveIntR(4);
                    errorString = new byte[len];
                    this.connection.receiveBytes(errorString, 0, len);
                    errNos = this.connection.receiveIntR(4);
                    len = this.connection.receiveIntR(4);
                    errorObject = new byte[len];
                    this.connection.receiveBytes(errorObject, 0, len);
                    this.datablock = null;
                    this.connection.resetSocket();
                    if (!this.connection.getAutoCommit()) {
                        this.connection.rollback();
                    }
                    etothrow = new SQLException(new String(errorString));
                    this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                    throw etothrow;
                }
            }
            this.datablock = null;
            this.pendingReadForaMsgType();
            this.connection.resetSocket();
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
            try {
                this.stream.close();
                new File(this.fileName).delete();
            }
            catch (IOException ex) {
                // empty catch block
            }
            etothrow = new SQLException("Query was cancelled");
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    public void cleanupUnload(String errmsg, boolean rmFile) throws SQLException {
        String method = "cleanupUnload";
        this.connection.LOGGER.entry(this.getClass(), method, errmsg, rmFile);
        if (rmFile) {
            new File(this.fileName).delete();
        }
        this.connection.cancel();
        this.clearUnloadData();
        this.connection.STATE = 1;
        if (!this.connection.getAutoCommit()) {
            this.connection.rollback();
        }
        SQLException etothrow = new SQLException(errmsg);
        this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
        throw etothrow;
    }

    private void clearUnloadData() throws SQLException {
        String method = "clearUnloadData";
        this.connection.LOGGER.entry(this.getClass(), method);
        block8: while (true) {
            int id;
            if ((id = this.connection.receiveInt()) == 0) {
                id = this.connection.receiveInt();
                id = this.connection.receiveInt();
                id = this.connection.receiveInt();
                switch (id) {
                    case 1: {
                        int nBytes = this.connection.receiveIntR(4);
                        this.connection.receiveBytes(nBytes);
                        continue block8;
                    }
                    case 3: {
                        continue block8;
                    }
                    case 2: {
                        this.connection.receiveIntR(4);
                        int nBytes = this.connection.receiveIntR(4);
                        this.connection.receiveBytes(nBytes);
                        this.connection.receiveIntR(4);
                        nBytes = this.connection.receiveIntR(4);
                        this.connection.receiveBytes(nBytes);
                        continue block8;
                    }
                }
                SQLException etothrow = new SQLException("Invalid ID: " + id);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
            int command_number = this.connection.receiveIntR(4);
            int cmdleng = this.connection.receiveIntR(4);
            switch (id) {
                case 90: {
                    this.connection.LOGGER.exit(this.getClass(), method);
                    return;
                }
            }
            this.connection.receiveBytes(cmdleng);
        }
    }

    public void pendingReadForaMsgType() throws SQLException {
        this.connection.receiveChar();
        int size = this.connection.receiveIntR(4);
        byte[] a = new byte[size];
        this.connection.receiveBytes(a, 0, size);
    }
}

