/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.RealStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class CacheOutputStream
extends OutputStream {
    private RealStream stream;
    private byte[] buffer = null;
    private int currentPosition = 0;
    private int capacity;
    private long streamPosition;
    private boolean closed = false;

    public CacheOutputStream(RealStream realStream, long l) {
        this.stream = realStream;
        this.streamPosition = l;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.stream.closed || this.closed) {
            throw new IOException("This stream object is closed");
        }
        if (this.buffer == null) {
            this.capacity = n2;
            this.buffer = new byte[this.capacity];
            System.arraycopy(byArray, n, this.buffer, 0, n2);
            this.currentPosition = n2;
        } else if (this.currentPosition + n2 > this.capacity) {
            this.capacity = this.currentPosition + n2;
            byte[] byArray2 = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, byArray2, 0, this.currentPosition);
            System.arraycopy(byArray, n, byArray2, this.currentPosition, n2);
            this.buffer = byArray2;
            this.currentPosition = this.capacity;
        } else {
            System.arraycopy(byArray, n, this.buffer, this.currentPosition, n2);
            this.currentPosition += n2;
        }
        if (this.currentPosition > 10000000) {
            try {
                this.stream.sendBytes(this.streamPosition, this.buffer, 0, this.currentPosition);
                this.streamPosition += (long)this.currentPosition;
                this.currentPosition = 0;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.stream.closed || this.closed) {
            throw new IOException("This stream object is closed");
        }
        try {
            this.stream.sendBytes(this.streamPosition, this.buffer, 0, this.currentPosition);
            this.stream.getStreamSize();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

