/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.VersionInfo;
import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;

public final class CacheDatabaseMetaData
implements DatabaseMetaData {
    private CacheConnection connection;

    CacheDatabaseMetaData(CacheConnection cacheConnection) {
        this.connection = cacheConnection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public synchronized String getURL() throws SQLException {
        return this.connection.url;
    }

    @Override
    public synchronized String getUserName() throws SQLException {
        return this.connection.user;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Cache";
    }

    @Override
    public synchronized String getDatabaseProductVersion() throws SQLException {
        return this.connection.serverVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "InterSystems Cache JDBC";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return VersionInfo.getClientVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return VersionInfo.getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return VersionInfo.getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public synchronized String getIdentifierQuoteString() throws SQLException {
        if (this.connection.delimitedIds == 1) {
            return "\"";
        }
        return " ";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "%AFTERHAVING,%ALPHAUP,%ALTER,%ALTER_USER,%BEGTRANS,%CHECKPRIV,%CREATE_ROLE,%CREATE_USER,%DBUGFULL,%DELDATA,%DESCRIPTION,%DROP_ANY_ROLE,%DROP_USER,%EXACT,%EXTERNAL,%FILE,%FOREACH,%FULL,%GRANT_ANY_PRIVILEGE,%GRANT_ANY_ROLE,%INORDER,%INTERNAL,%INTEXT,%INTRANS,%INTRANSACTION,%MCODE,%NOCHECK,%NODELDATA,%NOINDEX,%NOLOCK,%NOTRIGGER,%NUMROWS,%ODBCOUT,%ROUTINE,%ROWCOUNT,%STARTSWITH,%STRING,%THRESHOLD,%UPPER,AVG,BETWEEN,BIT_LENGTH,CHARACTER_LENGTH,CHAR_LENGTH,COALESCE,COBOL,CONVERT,COUNT,ENDEXEC,EXISTS,EXTRACT,FILE,FORTRAN,INSENSITIVE,LOWER,MAX,MIN,NULLIF,OCTET_LENGTH,OVERLAPS,PASCAL,PLI,POSITION,SQLCODE,SQLERROR,SUBSTRING,SUM,TRANSLATE,TRIM,UPPER";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,CEILING,COS,COT,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,LCASE,LEFT,LENGTH,LTRIM,REPEAT,RIGHT,RTRIM,SPACE,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "IFNULL";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "%";
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "Schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "Stored Procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public synchronized int getDefaultTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        switch (n) {
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return n2 == 4 || n2 == 12;
            }
            case 1: {
                return n2 == 4 || n2 == 12 || n2 == 91 || n2 == 92;
            }
            case 12: {
                return n2 == 4 || n2 == 12 || n2 == 91 || n2 == 92 || n2 == 93;
            }
            case 91: {
                return n2 == 4 || n2 == 12 || n2 == 91 || n2 == 93;
            }
            case 92: {
                return n2 == 4 || n2 == 12 || n2 == 92;
            }
            case 93: {
                return n2 == 12 || n2 == 91 || n2 == 92;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.is20081plus();
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public synchronized boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (n == 1) {
            return this.connection.supportedIsolationLevels % 2 == 1;
        }
        if (n == 2) {
            return this.connection.supportedIsolationLevels == 3;
        }
        if (n == 4 || n == 8 || n == 0) {
            return false;
        }
        throw new SQLException("Information type out of range", "S1096", 473);
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_PROCEDURES, string3, string2, null, null);
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_PROCEDURECOL, string3, string4, string2, null);
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4;
        if (stringArray == null || stringArray.length == 0) {
            string4 = "TABLE,VIEW";
        } else {
            string4 = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string4 = string4 + "," + stringArray[i];
            }
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_TABLES, string3, string4, string2, null);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_SCHEMAS, "%", null, null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_CATALOGS, null, null, null, null);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_TABLETYPES, null, null, null, null);
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_COLUMNS, string3, string4, string2, null);
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_COLUMNPRIV, string3, string4, string2, null);
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_TABLEPRIV, string3, string2, null, null);
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_BESTROWID, string3, string2, null, null);
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_VERSIONCOL, string3, string2, null, null);
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_PRIMARYKEYS, string3, string2, null, null);
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_IMPORTEDKEYS, string3, string2, null, null);
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_EXPORTEDKEYS, string3, string2, null, null);
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string5 == null) {
            string5 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string6 == null || string6.length() == 0) {
            string6 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_CROSSREFERENCE, string3, string6, string2, string5);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_TYPEINFO, null, null, null, null);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (bl) {
            return this.executeCatalogQuery(CacheConnection.JDBC_INDEXINFO, string3, string2, "0", null);
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_INDEXINFO, string3, string2, "1", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized ResultSet executeCatalogQuery(byte[] byArray, String string, String string2, String string3, String string4) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            CacheCallableStatement cacheCallableStatement = new CacheCallableStatement(this.connection);
            cacheCallableStatement.serverCursorNumber = ++this.connection.nextServerCursorNumber;
            this.connection.outMessage.wire.writeHeader(cacheCallableStatement.serverCursorNumber, byArray);
            this.connection.outMessage.wire.set(1);
            if (string4 != null) {
                this.connection.outMessage.wire.set(4);
            } else if (string3 != null) {
                this.connection.outMessage.wire.set(3);
            } else if (string2 != null) {
                this.connection.outMessage.wire.set(2);
            } else if (string != null) {
                this.connection.outMessage.wire.set(1);
            } else {
                this.connection.outMessage.wire.set(0);
            }
            if (string != null) {
                this.connection.outMessage.wire.set(string);
                if (string2 != null) {
                    this.connection.outMessage.wire.set(string2);
                    if (string3 != null) {
                        this.connection.outMessage.wire.set(string3);
                        if (string4 != null) {
                            this.connection.outMessage.wire.set(string4);
                        }
                    }
                }
            }
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            if (cacheCallableStatement.input.readHeader(cacheCallableStatement.serverCursorNumber, 0, 100) == 100) {
                cacheCallableStatement.fetchDone = true;
            }
            cacheCallableStatement.input.wire.getInt();
            cacheCallableStatement.columnInfo(cacheCallableStatement.input.wire);
            if (cacheCallableStatement.input.readHeader(cacheCallableStatement.serverCursorNumber, 0, 100) == 100) {
                cacheCallableStatement.fetchDone = true;
            }
            return new CacheResultSet(cacheCallableStatement);
        }
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        return n != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n != 1005;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_UDTS, null, null, null, null);
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.is20081plus();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        if (string == null) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_SUPER_TYPES, string, string2, string3, null);
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        if (string == null) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_SUPER_TABLES, string, string2, string3, null);
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        if (string == null) {
            string = "%";
        }
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_GET_ATTRIBUTES, string, string2, string3, string4);
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        String string = this.connection.serverVersion;
        try {
            string = string.substring(22, string.length());
            int n = string.indexOf(46);
            return Integer.parseInt(string.substring(0, n));
        }
        catch (Exception exception) {
            return VersionInfo.getMajorVersion();
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        String string = this.connection.serverVersion;
        try {
            string = string.substring(22, string.length());
            int n = string.indexOf(46);
            string = string.substring(n + 1, string.length());
            n = string.indexOf(46);
            return Integer.parseInt(string.substring(0, n));
        }
        catch (Exception exception) {
            return VersionInfo.getMinorVersion();
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return VersionInfo.getMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return VersionInfo.getMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_GET_FUNCTION_COLUMNS, string3, string4, string2, null);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_GET_FUNCTIONS, string3, string2, null, null);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.executeCatalogQuery(CacheConnection.JDBC_CLIENT_INFO_PROPERTIES, null, null, null, null);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        if (string2 == null) {
            string2 = "%";
        }
        return this.executeCatalogQuery(CacheConnection.JDBC_SCHEMAS, string2, null, null, null);
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return this;
        }
        throw new SQLException("Receiver not a wrapper");
    }

    private boolean is20081plus() throws SQLException {
        return this.getDatabaseMajorVersion() >= 2008 && this.getDatabaseMinorVersion() >= 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }
}

