/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.Logger;
import com.jalapeno.tools.objects.DefaultMappingTool;
import com.jalapeno.tools.objects.JavaCacheClassMapper;
import com.jalapeno.tools.objects.MappingToolInterface;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SerializationSupport {
    protected MappingToolInterface mNameMapper;
    private JavaCacheClassMapper mTypeMapper;
    protected PrintWriter logger;
    private Map mTypeMap;

    protected SerializationSupport(Map map, PrintWriter printWriter) {
        this.logger = printWriter;
        if (this.logger == null && Logger.debugOn() && Logger.getDebugCache()) {
            this.logger = Logger.out;
        }
        this.mTypeMap = map;
        this.mNameMapper = new DefaultMappingTool();
        if (this.mTypeMap == null) {
            if (this.mTypeMapper == null) {
                this.mTypeMapper = new JavaCacheClassMapper();
            }
            this.mTypeMap = new HashMap();
        }
    }

    protected Map getMetaData(Map map, Class clazz) throws SQLException {
        String string = (String)this.mTypeMap.get(clazz.getName());
        if (string == null && this.mTypeMapper != null) {
            try {
                this.mTypeMapper.mapClass(clazz);
            }
            catch (Exception exception) {
                if (this.logger != null) {
                    exception.printStackTrace(this.logger);
                }
                throw new SQLException("Failed to get Type Map for class " + clazz.getName() + ". Reason: " + exception.toString());
            }
            this.mTypeMap.putAll(this.mTypeMapper.getTypeMap());
            string = (String)this.mTypeMap.get(clazz.getName());
        }
        if (string == null) {
            throw new SQLException("No type mapping for class " + clazz.getName());
        }
        Map map2 = this.processMetadata(string, map);
        return map2;
    }

    private Map processMetadata(String string, Map map) throws SQLException {
        String string2;
        Object v = map.get(string);
        if (v == null) {
            throw new SQLException("No metadata for Cache class " + string);
        }
        if (v instanceof Map) {
            if (this.logger != null) {
                this.logger.println("Already have metadata for class " + string);
            }
            return (Map)v;
        }
        if (this.logger != null) {
            this.logger.println("Getting metadata for class " + string);
        }
        if (!string.equals(string2 = SysListProxy.getString(v))) {
            throw new SQLException("Unexpected metadata. Expected for class " + string + " got for " + string2);
        }
        Object object = SysListProxy.getSysList(v);
        HashMap<String, Metadata> hashMap = new HashMap<String, Metadata>();
        while (!SysListProxy.atEnd(object)) {
            String string3 = SysListProxy.getString(object);
            int n = SysListProxy.getInteger(object);
            int n2 = SysListProxy.getInteger(object);
            int n3 = SysListProxy.getInteger(object);
            boolean bl = !SysListProxy.getBoolean(object);
            hashMap.put(string3, new Metadata(n, n2, n3, bl));
            if (this.logger == null) continue;
            this.logger.println("\t" + string3 + ": " + n + "-" + n2 + "-" + n3 + "-" + bl);
        }
        map.put(string2, hashMap);
        return hashMap;
    }

    protected static class Metadata {
        int ii;
        int jj;
        int kk;
        boolean isObj;

        public Metadata(int n, int n2, int n3, boolean bl) {
            this.ii = n;
            this.jj = n2;
            this.kk = n3;
            this.isObj = bl;
        }
    }
}

