/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.CacheObject;
import com.intersys.cache.metadata.AbstractCacheField;
import com.intersys.classes.BinaryStream;
import com.intersys.classes.CharacterStream;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheInputStream;
import com.intersys.objects.CacheOutputStream;
import com.intersys.objects.CacheReader;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.SystemError;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;

public class StreamAccessHelper {
    public static final int CHAR_STREAM_BUFFER_LEN = 8192;
    public static final char[] CHAR_STREAM_BUFFER = new char[8192];
    public static final int BYTE_STREAM_BUFFER_LEN = 8192;
    public static final byte[] BYTE_STREAM_BUFFER = new byte[8192];

    public static void setStreamValue(AbstractCacheField abstractCacheField, Object object, CacheObject cacheObject) throws CacheException {
        try {
            if (object == null) {
                return;
            }
            if (object instanceof Reader) {
                StreamAccessHelper.setReader(abstractCacheField, cacheObject, (Reader)object);
            } else if (object instanceof InputStream) {
                StreamAccessHelper.setBStream(abstractCacheField, cacheObject, (InputStream)object);
            } else if (object instanceof String) {
                CacheWriter cacheWriter = (CacheWriter)abstractCacheField.getWriter(cacheObject);
                cacheWriter.rewind();
                cacheWriter.write((String)object);
            } else if (object instanceof byte[]) {
                CacheOutputStream cacheOutputStream = (CacheOutputStream)abstractCacheField.getBStream(cacheObject);
                cacheOutputStream.rewind();
                cacheOutputStream.write((byte[])object);
            } else if (object instanceof char[]) {
                CacheWriter cacheWriter = (CacheWriter)abstractCacheField.getWriter(cacheObject);
                cacheWriter.rewind();
                cacheWriter.write((char[])object);
            } else if (object instanceof Serializable) {
                CacheOutputStream cacheOutputStream = (CacheOutputStream)abstractCacheField.getBStream(cacheObject);
                cacheOutputStream.rewind();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(cacheOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                objectOutputStream.close();
            } else {
                throw new CacheException("Do not know how to write to stream instance of " + object.getClass().getName());
            }
            return;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read/write property " + abstractCacheField.getDeclaringCacheClass().getName() + "." + abstractCacheField.getName());
        }
    }

    private static void setReader(AbstractCacheField abstractCacheField, CacheObject cacheObject, Reader reader) throws CacheException, IOException {
        char[] cArray;
        int n;
        Writer writer = abstractCacheField.getWriter(cacheObject);
        while (reader.ready() && (n = reader.read(cArray = new char[8192])) >= 0) {
            writer.write(cArray, 0, n);
        }
    }

    private static void setBStream(AbstractCacheField abstractCacheField, CacheObject cacheObject, InputStream inputStream) throws CacheException, IOException {
        int n;
        OutputStream outputStream = abstractCacheField.getBStream(cacheObject);
        int n2 = 8192;
        byte[] byArray = new byte[n2];
        while (inputStream.available() > 0 && (n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static Object copyStream(Object object, Object object2) throws CacheException, IOException, ClassNotFoundException {
        if (object instanceof CharacterStream) {
            object = new CacheReader((CharacterStream)object);
        } else if (object instanceof BinaryStream) {
            object = new CacheInputStream((BinaryStream)object);
        }
        if (object instanceof InputStream) {
            if (object2 instanceof OutputStream) {
                StreamAccessHelper.readStreamToAnotherStream((InputStream)object, (OutputStream)object2);
                return null;
            }
            if (object2 instanceof Class) {
                Class clazz = (Class)object2;
                InputStream inputStream = (InputStream)object;
                if (clazz.isAssignableFrom(byte[].class)) {
                    byte[] byArray = StreamAccessHelper.readStreamToByteArray(inputStream);
                    return byArray;
                }
                if (clazz.isAssignableFrom(String.class)) {
                    byte[] byArray = StreamAccessHelper.readStreamToByteArray(inputStream);
                    return new String(byArray);
                }
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
                Object object3 = objectInputStream.readObject();
                objectInputStream.close();
                return object3;
            }
            throw new SystemError("Unknown type: " + object2.getClass().getName());
        }
        if (object instanceof Reader) {
            if (object2 instanceof Writer) {
                StreamAccessHelper.readStreamToAnotherStream((Reader)object, (Writer)object2);
                return null;
            }
            if (object2 instanceof Class) {
                Class clazz = (Class)object2;
                String string = StreamAccessHelper.readStreamToCharArray((Reader)object);
                if (clazz.isAssignableFrom(byte[].class)) {
                    return string.getBytes();
                }
                if (clazz.isAssignableFrom(char[].class)) {
                    return string.toCharArray();
                }
                if (clazz.isAssignableFrom(String.class)) {
                    return string;
                }
                throw new CacheException("Do not know how to set stream.");
            }
            throw new SystemError("Unknown type: " + object2.getClass().getName());
        }
        throw new SystemError("Unknown type: " + object.getClass().getName());
    }

    public static byte[] readStreamToByteArray(InputStream inputStream) throws CacheException {
        try {
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n > 0) {
                int n3 = inputStream.read(byArray, n2, n);
                n -= n3;
                n2 += n3;
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read stream.");
        }
    }

    public static String readStreamToCharArray(Reader reader) throws CacheException {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 8192;
            char[] cArray = new char[n2];
            while (reader.ready() && (n = reader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void readStreamToAnotherStream(InputStream inputStream, OutputStream outputStream) throws CacheException {
        try {
            while (inputStream.available() > 0) {
                byte[] byArray = BYTE_STREAM_BUFFER;
                // MONITORENTER : BYTE_STREAM_BUFFER
                int n = inputStream.read(BYTE_STREAM_BUFFER);
                if (n < 0) {
                    // MONITOREXIT : byArray
                    return;
                }
                outputStream.write(BYTE_STREAM_BUFFER, 0, n);
                // MONITOREXIT : byArray
            }
            return;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void readStreamToAnotherStream(Reader reader, Writer writer) throws CacheException {
        try {
            while (reader.ready()) {
                char[] cArray = CHAR_STREAM_BUFFER;
                // MONITORENTER : CHAR_STREAM_BUFFER
                int n = reader.read(CHAR_STREAM_BUFFER);
                if (n < 0) {
                    // MONITOREXIT : cArray
                    return;
                }
                writer.write(CHAR_STREAM_BUFFER, 0, n);
                // MONITOREXIT : cArray
            }
            return;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read stream.");
        }
    }
}

