/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskReference;
import org.jkiss.dbeaver.model.task.DBTTaskSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class CompositeTaskSettings
implements DBTTaskSettings<DBTTask> {
    private static final Log log = Log.getLog(CompositeTaskSettings.class);
    private List<TaskReference> tasks = new ArrayList<TaskReference>();
    private boolean ignoreErrors;

    public List<TaskReference> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<TaskReference> tasks) {
        this.tasks = tasks;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public void loadConfiguration(DBRRunnableContext runnableContext, Map<String, Object> config) {
        this.tasks.clear();
        Object tasksMapList = config.get("tasks");
        if (tasksMapList instanceof List) {
            for (Map taskMap : (List)tasksMapList) {
                String projectName = CommonUtils.toString(taskMap.get("project"));
                DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                if (project == null) {
                    log.error((Object)("Project '" + projectName + "' not found"));
                    continue;
                }
                String id = CommonUtils.toString(taskMap.get("id"));
                DBTTask task = project.getTaskManager().getTaskById(id);
                if (task == null) {
                    log.error((Object)("Task '" + id + "' not found in project '" + projectName + "'"));
                    continue;
                }
                TaskReference taskReference = new TaskReference();
                taskReference.setDisabled(CommonUtils.toBoolean(taskMap.get("disabled")));
                taskReference.setIgnoreErrors(CommonUtils.toBoolean(taskMap.get("ignoreErrors")));
                taskReference.setTask(task);
                this.tasks.add(taskReference);
            }
        }
        this.ignoreErrors = JSONUtils.getBoolean(config, (String)"ignoreErrors");
    }

    public void saveConfiguration(Map<String, Object> config) {
        ArrayList taskIds = new ArrayList();
        for (TaskReference tr : this.tasks) {
            LinkedHashMap<String, Object> taskMap = new LinkedHashMap<String, Object>();
            taskMap.put("id", tr.getTask().getId());
            taskMap.put("project", tr.getTask().getProject().getName());
            if (tr.isDisabled()) {
                taskMap.put("disabled", tr.isDisabled());
            }
            if (tr.isIgnoreErrors()) {
                taskMap.put("ignoreErrors", tr.isIgnoreErrors());
            }
            taskIds.add(taskMap);
        }
        config.put("tasks", taskIds);
        config.put("ignoreErrors", this.ignoreErrors);
    }

    public static class TaskReference
    implements DBTTaskReference {
        @NotNull
        private DBTTask task;
        private boolean disabled;
        private boolean ignoreErrors;

        @NotNull
        public DBTTask getTask() {
            return this.task;
        }

        public void setTask(DBTTask task) {
            this.task = task;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public boolean isIgnoreErrors() {
            return this.ignoreErrors;
        }

        public void setIgnoreErrors(boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
        }
    }
}

