/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks;

import com.dbeaver.ee.tasks.CompositeTaskSettings;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;

class CompositeTaskExecutor {
    @NotNull
    private DBRRunnableContext runnableContext;
    @NotNull
    private DBTTask task;
    @NotNull
    private Locale locale;
    @NotNull
    private Log log;
    @NotNull
    private PrintStream logStream;
    @NotNull
    DBTTaskExecutionListener listener;
    private Throwable lastTaskError;

    CompositeTaskExecutor(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, final @NotNull DBTTaskExecutionListener tl) {
        this.runnableContext = runnableContext;
        this.task = task;
        this.locale = locale;
        this.log = log;
        this.logStream = logStream;
        this.listener = new DBTTaskExecutionListener(){

            public void taskStarted(@NotNull Object task) {
                tl.taskStarted(task);
            }

            public void taskFinished(@NotNull Object task, @Nullable Object result, @Nullable Throwable error) {
                tl.taskFinished(task, result, error);
                CompositeTaskExecutor.this.lastTaskError = error;
            }

            public void subTaskFinished(@Nullable Throwable error) {
                tl.subTaskFinished(error);
            }
        };
    }

    void executeWithSettings(CompositeTaskSettings settings) throws DBException {
        this.listener.taskStarted((Object)settings);
        this.log.debug((Object)"Composite task execute");
        Throwable error = null;
        try {
            this.runnableContext.run(true, true, monitor -> {
                try {
                    this.runCompositeTask(monitor, settings);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            error = e.getTargetException();
        }
        catch (InterruptedException interruptedException) {
            this.log.debug((Object)"Task canceled");
        }
        if (error != null) {
            this.log.error((Object)error);
        }
        this.listener.taskFinished((Object)settings, null, error);
        this.log.debug((Object)"Composite task execute completed");
    }

    private void runCompositeTask(DBRProgressMonitor monitor, CompositeTaskSettings settings) throws DBException {
        List<CompositeTaskSettings.TaskReference> taskList = settings.getTasks();
        monitor.beginTask("Execute nested tasks", taskList.size());
        for (CompositeTaskSettings.TaskReference tr : taskList) {
            try {
                this.runTask(monitor, tr);
                if (this.lastTaskError != null) {
                    throw new DBException("Sub task '" + tr.getTask().getName() + "' failed");
                }
            }
            catch (DBException e) {
                if (!settings.isIgnoreErrors() && !tr.isIgnoreErrors()) {
                    throw e;
                }
                this.log.error((Object)e);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private void runTask(DBRProgressMonitor monitor, CompositeTaskSettings.TaskReference taskReference) throws DBException {
        monitor.subTask("Run task " + taskReference.getTask().getName());
        DBTTaskHandler handler = taskReference.getTask().getType().createHandler();
        handler.executeTask(this.runnableContext, taskReference.getTask(), this.locale, this.log, this.logStream, this.listener);
    }
}

