/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.IElementFilter;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class AuthModelSelector
extends Composite {
    private static final Log log = Log.getLog(DataSourceProviderRegistry.class);
    private IElementFilter<DBPAuthModelDescriptor> modelFilter;
    private IElementFilter<DBPAuthModelDescriptor> modelChangeFilter;
    private List<? extends DBPAuthModelDescriptor> allAuthModels;
    private DBPDataSourceContainer activeDataSource;
    private DBPAuthModelDescriptor selectedAuthModel;
    private Composite modelConfigPlaceholder;
    private IObjectPropertyConfigurator<DBPDataSourceContainer> authModelConfigurator;
    private Runnable changeListener;

    public AuthModelSelector(Composite parent, Runnable changeListener) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.changeListener = changeListener;
        this.modelConfigPlaceholder = UIUtils.createControlGroup((Composite)this, (String)UIConnectionMessages.dialog_connection_auth_group, (int)2, (int)768, (int)0);
    }

    public DBPAuthModelDescriptor getSelectedAuthModel() {
        return this.selectedAuthModel;
    }

    Composite getAuthPanelComposite() {
        return this.modelConfigPlaceholder;
    }

    public void setModelFiler(IElementFilter<DBPAuthModelDescriptor> filter) {
        this.modelFilter = filter;
    }

    public void setModelChangeFilter(IElementFilter<DBPAuthModelDescriptor> modelChangeFilter) {
        this.modelChangeFilter = modelChangeFilter;
    }

    public void clearSettings() {
        UIUtils.disposeChildControls((Composite)this.modelConfigPlaceholder);
    }

    public void loadSettings(DBPDataSourceContainer dataSourceContainer, DBPAuthModelDescriptor activeAuthModel, String defaultAuthModelId) {
        this.activeDataSource = dataSourceContainer;
        this.selectedAuthModel = activeAuthModel;
        this.allAuthModels = this.activeDataSource.getDriver() == DriverDescriptor.NULL_DRIVER ? DataSourceProviderRegistry.getInstance().getAllAuthModels() : DataSourceProviderRegistry.getInstance().getApplicableAuthModels(this.activeDataSource.getDriver());
        this.allAuthModels.removeIf(o -> this.modelFilter != null && !this.modelFilter.isValidElement(o));
        this.allAuthModels.sort((o1, o2) -> "native".equals(o1.getId()) ? -1 : ("native".equals(o2.getId()) ? 1 : o1.getName().compareTo(o2.getName())));
        if (this.selectedAuthModel == null && !CommonUtils.isEmpty((String)defaultAuthModelId)) {
            for (DBPAuthModelDescriptor dBPAuthModelDescriptor : this.allAuthModels) {
                if (!dBPAuthModelDescriptor.getId().equals(defaultAuthModelId)) continue;
                this.selectedAuthModel = dBPAuthModelDescriptor;
                dataSourceContainer.getConnectionConfiguration().setAuthModelId(this.selectedAuthModel.getId());
                break;
            }
            if (this.selectedAuthModel == null) {
                this.selectedAuthModel = this.allAuthModels.get(0);
                dataSourceContainer.getConnectionConfiguration().setAuthModelId(this.selectedAuthModel.getId());
            }
        }
        this.changeAuthModel();
    }

    private void changeAuthModel() {
        this.showAuthModelSettings();
    }

    protected void showAuthModelSettings() {
        Composite parentFolder = (Composite)UIUtils.getParentOfType((Control)this.modelConfigPlaceholder, TabFolder.class);
        if (parentFolder == null) {
            parentFolder = (Composite)UIUtils.getParentOfType((Control)this.modelConfigPlaceholder, Shell.class);
        }
        this.modelConfigPlaceholder.setRedraw(false);
        UIUtils.disposeChildControls((Composite)this.modelConfigPlaceholder);
        Label authModelLabel = UIUtils.createControlLabel((Composite)this.modelConfigPlaceholder, (String)UIConnectionMessages.dialog_connection_auth_group);
        Composite authModelComp = UIUtils.createComposite((Composite)this.modelConfigPlaceholder, (int)2);
        authModelComp.setLayoutData((Object)new GridData(768));
        final Combo authModelCombo = new Combo(authModelComp, 12);
        authModelCombo.setLayoutData((Object)new GridData(32));
        authModelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPAuthModelDescriptor newAuthModel = (DBPAuthModelDescriptor)AuthModelSelector.this.allAuthModels.get(authModelCombo.getSelectionIndex());
                if (AuthModelSelector.this.selectedAuthModel != newAuthModel) {
                    if (AuthModelSelector.this.modelChangeFilter != null && !AuthModelSelector.this.modelChangeFilter.isValidElement((Object)newAuthModel)) {
                        authModelCombo.select(AuthModelSelector.this.allAuthModels.indexOf(AuthModelSelector.this.selectedAuthModel));
                        return;
                    }
                    AuthModelSelector.this.selectedAuthModel = newAuthModel;
                    AuthModelSelector.this.activeDataSource.getConnectionConfiguration().setAuthModelId(AuthModelSelector.this.selectedAuthModel.getId());
                    AuthModelSelector.this.showAuthModelSettings();
                }
                AuthModelSelector.this.modelConfigPlaceholder.setFocus();
                AuthModelSelector.this.changeListener.run();
            }
        });
        Label authModelDescLabel = new Label(authModelComp, 0);
        authModelDescLabel.setLayoutData((Object)new GridData(768));
        for (DBPAuthModelDescriptor dBPAuthModelDescriptor : this.allAuthModels) {
            authModelCombo.add(dBPAuthModelDescriptor.getName());
        }
        if (this.selectedAuthModel != null) {
            authModelCombo.select(this.allAuthModels.indexOf(this.selectedAuthModel));
        }
        boolean bl = this.allAuthModels.size() >= 2;
        UIUtils.setControlVisible((Control)authModelLabel, (boolean)bl);
        UIUtils.setControlVisible((Control)authModelComp, (boolean)bl);
        ((Group)this.modelConfigPlaceholder).setText(bl ? UIConnectionMessages.dialog_connection_auth_group : String.valueOf(UIConnectionMessages.dialog_connection_auth_group) + " (" + this.selectedAuthModel.getName() + ")");
        this.authModelConfigurator = null;
        UIPropertyConfiguratorDescriptor uiConfiguratorDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(this.selectedAuthModel.getImplClassName());
        if (uiConfiguratorDescriptor != null) {
            try {
                this.authModelConfigurator = uiConfiguratorDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        if (this.authModelConfigurator != null) {
            this.authModelConfigurator.createControl(this.modelConfigPlaceholder, () -> this.changeListener.run());
            this.authModelConfigurator.loadSettings((Object)this.activeDataSource);
        } else if (this.selectedAuthModel != null && !CommonUtils.isEmpty((String)this.selectedAuthModel.getDescription())) {
            Label descLabel = new Label(this.modelConfigPlaceholder, 0);
            descLabel.setText(this.selectedAuthModel.getDescription());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            descLabel.setLayoutData((Object)gd);
        }
        this.modelConfigPlaceholder.setRedraw(true);
        if (this.modelConfigPlaceholder.getSize().x > 0 && parentFolder != null) {
            parentFolder.layout(true, true);
        }
    }

    public boolean isComplete() {
        return this.authModelConfigurator == null || this.authModelConfigurator.isComplete();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        if (this.authModelConfigurator != null) {
            this.authModelConfigurator.saveSettings((Object)dataSource);
        }
    }
}

