/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.model;

import com.dbeaver.ee.model.NoSQLDialect;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;

public class CouchbaseSQLDialect
extends NoSQLDialect {
    public static final CouchbaseSQLDialect INSTANCE = new CouchbaseSQLDialect();
    public static final String[][] DEFAULT_IDENTIFIER_QUOTES = new String[][]{{"`", "`"}};

    public CouchbaseSQLDialect() {
        this.addKeywords(Arrays.asList("limit", "offset"), DBPKeywordType.KEYWORD);
    }

    @NotNull
    public String getDialectId() {
        return "couchbase";
    }

    @NotNull
    public String getDialectName() {
        return "Couchbase";
    }

    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    public String addFiltersToQuery(DBRProgressMonitor monitor, DBPDataSource dataSource, String query, DBDDataFilter filter) {
        return SQLSemanticProcessor.injectFiltersToQuery((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)query, (DBDDataFilter)filter);
    }

    @NotNull
    public String[][] getIdentifierQuoteStrings() {
        return DEFAULT_IDENTIFIER_QUOTES;
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public boolean supportsAliasInSelect() {
        return false;
    }

    public boolean supportsAliasInUpdate() {
        return false;
    }

    public boolean supportsSubqueries() {
        return false;
    }
}

