/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.model.document.handlers;

import com.dbeaver.ee.model.document.handlers.DocumentBooleanValueHandler;
import com.dbeaver.ee.model.document.handlers.DocumentContentValueHandler;
import com.dbeaver.ee.model.document.handlers.DocumentListValueHandler;
import com.dbeaver.ee.model.document.handlers.DocumentMapValueHandler;
import com.dbeaver.ee.model.document.handlers.DocumentNumberValueHandler;
import com.dbeaver.ee.model.document.handlers.DocumentStringValueHandler;
import com.dbeaver.ee.model.document.handlers.DocumentTimestampValueHandler;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class DocumentValueHandlerProvider
implements DBDValueHandlerProvider {
    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        switch (typedObject.getDataKind()) {
            case BOOLEAN: {
                return DocumentBooleanValueHandler.INSTANCE;
            }
            case NUMERIC: {
                return new DocumentNumberValueHandler(typedObject, preferences);
            }
            case STRING: {
                return DocumentStringValueHandler.INSTANCE;
            }
            case DATETIME: {
                return new DocumentTimestampValueHandler(preferences);
            }
            case ARRAY: {
                return DocumentListValueHandler.INSTANCE;
            }
            case STRUCT: {
                return DocumentMapValueHandler.INSTANCE;
            }
            case BINARY: {
                return DocumentContentValueHandler.INSTANCE;
            }
        }
        return DocumentStringValueHandler.INSTANCE;
    }
}

