/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.config;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.registry.CPCloudConfigurationProviderCustom;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class AwsLocalConfigurationProvider
implements CPCloudConfigurationProviderCustom<AWSCloudConfiguration> {
    private static final Log log = Log.getLog(AwsLocalConfigurationProvider.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private List<AWSCloudConfiguration> awsConfigs;
    private static final String CLOUD_CONFIG_FOLDER = ".cloud-data";
    private static final String CLOUD_CONFIG_FILE = "aws-clouds.json";

    @NotNull
    public AWSCloudConfiguration[] getCloudConfigurations() {
        if (this.awsConfigs == null) {
            ArrayList<AWSCloudConfiguration> cfgList = new ArrayList<AWSCloudConfiguration>();
            File cloudConfigFile = this.getCloudConfigFile(false);
            if (cloudConfigFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStreamReader cr = new InputStreamReader((InputStream)new FileInputStream(cloudConfigFile), StandardCharsets.UTF_8);){
                        AWSCloudConfiguration[] awsConfigs = (AWSCloudConfiguration[])this.gson.fromJson((Reader)cr, AWSCloudConfiguration[].class);
                        if (this.useSecureStorage()) {
                            AWSCloudConfiguration[] aWSCloudConfigurationArray = awsConfigs;
                            int n = awsConfigs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                AWSCloudConfiguration cfg = aWSCloudConfigurationArray[n2];
                                this.readAuthParametersFromPreferences(cfg);
                                ++n2;
                            }
                        }
                        Collections.addAll(cfgList, awsConfigs);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            this.awsConfigs = cfgList;
        }
        return this.awsConfigs.toArray(new AWSCloudConfiguration[0]);
    }

    private boolean useSecureStorage() {
        return DBWorkbench.getPlatform().getApplication().getSecureStorage().useSecurePreferences();
    }

    private ISecurePreferences getCloudPrefNode(AWSCloudConfiguration cfg) {
        DBASecureStorage secureStorage = DBWorkbench.getPlatform().getApplication().getSecureStorage();
        ISecurePreferences securePreferences = secureStorage.getSecurePreferences();
        return securePreferences.node("aws").node("credentials").node(cfg.getCloudId());
    }

    private void readAuthParametersFromPreferences(AWSCloudConfiguration cfg) {
        try {
            ISecurePreferences cloudPrefNode = this.getCloudPrefNode(cfg);
            String accessKey = cloudPrefNode.get("access-key", null);
            String secretKey = cloudPrefNode.get("secret-key", null);
            if (!CommonUtils.isEmpty((String)accessKey)) {
                cfg.getCredentials().setAwsAccessKey(accessKey);
            }
            if (!CommonUtils.isEmpty((String)secretKey)) {
                cfg.getCredentials().setAwsSecretKey(secretKey);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private boolean saveAuthParametersToPreferences(AWSCloudConfiguration cfg) {
        try {
            ISecurePreferences cloudPrefNode = this.getCloudPrefNode(cfg);
            String accessKey = cfg.getCredentials().getAwsAccessKey();
            String secretKey = cfg.getCredentials().getAwsSecretKey();
            if (!CommonUtils.isEmpty((String)accessKey)) {
                cloudPrefNode.put("access-key", accessKey, true);
            }
            if (!CommonUtils.isEmpty((String)secretKey)) {
                cloudPrefNode.put("secret-key", secretKey, true);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    private void removeAuthParametersToPreferences(AWSCloudConfiguration cfg) {
    }

    @NotNull
    public AWSCloudConfiguration createConfiguration() {
        return new AWSCloudConfiguration();
    }

    public void saveConfigurations(@NotNull Collection<AWSCloudConfiguration> configurations) {
        this.awsConfigs = new ArrayList<AWSCloudConfiguration>(configurations);
        boolean securePropsSaved = false;
        if (this.useSecureStorage()) {
            securePropsSaved = true;
            for (AWSCloudConfiguration cfg : this.awsConfigs) {
                if (this.saveAuthParametersToPreferences(cfg)) continue;
                securePropsSaved = false;
            }
        }
        this.flushConfiguration(!securePropsSaved);
    }

    private void flushConfiguration(boolean saveSecureProperties) {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting().setLenient();
        if (!saveSecureProperties) {
            builder.addSerializationExclusionStrategy((ExclusionStrategy)new SecurePropertiesExclusionStrategy());
        }
        Gson saveGson = builder.create();
        File cloudConfigFile = this.getCloudConfigFile(true);
        ContentUtils.makeFileBackup((File)cloudConfigFile);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStreamWriter cr = new OutputStreamWriter((OutputStream)new FileOutputStream(cloudConfigFile), StandardCharsets.UTF_8);){
                JsonWriter jsonWriter = saveGson.newJsonWriter((Writer)cr);
                saveGson.toJson(this.awsConfigs, this.awsConfigs.getClass(), jsonWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private File getCloudConfigFile(boolean create) {
        return new File(this.getCloudConfigFolder(create), CLOUD_CONFIG_FILE);
    }

    @NotNull
    private File getCloudConfigFolder(boolean create) {
        File cloudsFolder = new File(DBWorkbench.getPlatform().getWorkspace().getMetadataFolder(), CLOUD_CONFIG_FOLDER);
        if (create && !cloudsFolder.exists() && !cloudsFolder.mkdirs()) {
            log.error((Object)("Cannot create directory '" + cloudsFolder.getAbsolutePath() + "'"));
        }
        return cloudsFolder;
    }

    private static class EmptyExclusionStrategy
    implements ExclusionStrategy {
        private EmptyExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }

    private class SecurePropertiesExclusionStrategy
    implements ExclusionStrategy {
        private SecurePropertiesExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return AwsLocalConfigurationProvider.this.useSecureStorage() && fieldAttributes.getAnnotation(SecureProperty.class) != null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

