/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.auth;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.registry.CPCloudSessionProvider;
import com.dbeaver.net.auth.iam.AuthModelIAMCredentials;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.access.DBASession;
import org.jkiss.dbeaver.model.auth.DBAAuthSpace;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class AwsLocalSessionProvider
implements CPCloudSessionProvider<AWSCloud> {
    @Nullable
    public CPCloudSession openSession(@NotNull AWSCloud cloud) throws DBException {
        String arn = null;
        AWSCloudConfiguration configuration = cloud.getCloudConfiguration();
        AuthModelIAMCredentials iamCredentials = configuration.getCredentials();
        AwsCredentialsProvider credentialsProvider = iamCredentials.getAuthCredentialsProvider(null);
        AwsCredentials awsCredentials = credentialsProvider.resolveCredentials();
        ArrayList<AWSCloudZone> useZones = new ArrayList<AWSCloudZone>();
        String[] stringArray = configuration.getDefaultRegions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String regionId = stringArray[n2];
            useZones.add(AWSCloudZone.valueOf((Region)Region.of((String)regionId)));
            ++n2;
        }
        DBASession mainSession = DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession((DBAAuthSpace)DBWorkbench.getPlatform().getWorkspace());
        return new AWSCloudSession(mainSession, cloud, arn, awsCredentials, useZones.toArray(new AWSCloudZone[0]));
    }
}

