/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.model;

import java.sql.SQLException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SnowflakeExecutionContext
extends GenericExecutionContext {
    public SnowflakeExecutionContext(JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, GenericCatalog catalog, GenericSchema schema) throws DBCException {
        super.setDefaultCatalog(monitor, catalog, schema);
        DBPConnectionConfiguration connectionConfiguration = this.getDataSource().getContainer().getConnectionConfiguration();
        String databaseName = connectionConfiguration.getDatabaseName();
        if (schema == null && catalog != null && catalog.getName().equals(databaseName)) {
            this.useDefaultSchema(monitor);
        }
    }

    void useDefaultSchema(DBRProgressMonitor monitor) throws DBCException {
        String schemaName = this.getDefaultSchemaName();
        if (schemaName.isEmpty()) {
            return;
        }
        this.useSchemaWithName(monitor, schemaName);
    }

    private String getDefaultSchemaName() {
        return CommonUtils.notEmpty((String)this.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-schema@"));
    }

    private void useSchemaWithName(DBRProgressMonitor monitor, String schemaName) throws DBCException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement dbStat = session.createStatement();){
                    dbStat.executeUpdate("USE SCHEMA " + schemaName);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
    }
}

