/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.AbstractRoutingDirectionStrategy;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

class WestToEastRoutingStrategy
extends AbstractRoutingDirectionStrategy {
    WestToEastRoutingStrategy() {
    }

    @Override
    public double getPortPositionOnHyperNode(LPort port) {
        return port.getNode().getPosition().y + port.getPosition().y + port.getAnchor().y;
    }

    @Override
    public PortSide getSourcePortSide() {
        return PortSide.EAST;
    }

    @Override
    public PortSide getTargetPortSide() {
        return PortSide.WEST;
    }

    @Override
    public void calculateBendPoints(HyperEdgeSegment hyperNode, double startPos, double edgeSpacing) {
        double x = startPos + (double)hyperNode.getRoutingSlot() * edgeSpacing;
        for (LPort port : hyperNode.getPorts()) {
            double sourcey = port.getAbsoluteAnchor().y;
            for (LEdge edge : port.getOutgoingEdges()) {
                if (edge.isSelfLoop()) continue;
                LPort target = edge.getTarget();
                double targety = target.getAbsoluteAnchor().y;
                if (!(Math.abs(sourcey - targety) > 0.001)) continue;
                KVector point1 = new KVector(x, sourcey);
                edge.getBendPoints().add((Object)point1);
                this.addJunctionPointIfNecessary(edge, hyperNode, point1, true);
                KVector point2 = new KVector(x, targety);
                edge.getBendPoints().add((Object)point2);
                this.addJunctionPointIfNecessary(edge, hyperNode, point2, true);
            }
        }
    }
}

