/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SelfLoopPreProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Self-Loop pre-processing", 1.0f);
        for (LNode lnode : graph.getLayerlessNodes()) {
            if (!SelfLoopHolder.needsSelfLoopProcessing(lnode)) continue;
            SelfLoopHolder slHolder = SelfLoopHolder.install(lnode);
            this.hideSelfLoops(slHolder);
            this.hidePorts(slHolder);
        }
        progressMonitor.done();
    }

    private void hideSelfLoops(SelfLoopHolder slHolder) {
        slHolder.getSLHyperLoops().stream().flatMap(slLoop -> slLoop.getSLEdges().stream()).map(slEdge -> slEdge.getLEdge()).forEach(lEdge -> this.hideSelfLoop((LEdge)((Object)lEdge)));
    }

    private void hideSelfLoop(LEdge lEdge) {
        lEdge.setSource(null);
        lEdge.setTarget(null);
    }

    private void hidePorts(SelfLoopHolder slHolder) {
        if (((PortConstraints)slHolder.getLNode().getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
            return;
        }
        for (SelfLoopPort slPort : slHolder.getSLPortMap().values()) {
            if (!slPort.hadOnlySelfLoops()) continue;
            LPort lPort = slPort.getLPort();
            lPort.setNode(null);
            slPort.setHidden(true);
            slHolder.setPortsHidden(true);
            LNode dummy = (LNode)((Object)lPort.getProperty(InternalProperties.PORT_DUMMY));
            if (dummy == null) continue;
            Layer layer = dummy.getLayer();
            if (layer == null) {
                dummy.getGraph().getLayerlessNodes().remove((Object)dummy);
                continue;
            }
            layer.getNodes().remove((Object)dummy);
            if (!layer.getNodes().isEmpty()) continue;
            layer.getGraph().getLayers().remove(layer);
        }
    }
}

