/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.GraphCompactionStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.GreedySwitchType;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.NodePromotionStrategy;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.alg.layered.options.WrappingStrategy;
import org.eclipse.elk.alg.layered.p5edges.EdgeRouterFactory;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.options.PortConstraints;

final class GraphConfigurator {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.INNERMOST_NODE_MARGIN_CALCULATOR).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_AND_NODE_SIZE_PROCESSOR).addBefore((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LAYER_SIZE_AND_GRAPH_HEIGHT_CALCULATOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> LABEL_MANAGEMENT_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.CENTER_LABEL_MANAGEMENT_PROCESSOR).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.END_NODE_PORT_LABEL_MANAGEMENT_PROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HIERARCHICAL_ADDITIONS = LayoutProcessorConfiguration.create().addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HIERARCHICAL_NODE_RESIZER);
    private final AlgorithmAssembler<LayeredPhases, LGraph> algorithmAssembler = AlgorithmAssembler.create(LayeredPhases.class);
    private static final double MIN_EDGE_SPACING = 2.0;

    GraphConfigurator() {
    }

    private void configureGraphProperties(LGraph lgraph) {
        Integer randomSeed;
        Direction direction;
        double edgeSpacing = (Double)lgraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE);
        if (edgeSpacing < 2.0) {
            lgraph.setProperty(LayeredOptions.SPACING_EDGE_EDGE, 2.0);
        }
        if ((direction = (Direction)lgraph.getProperty(LayeredOptions.DIRECTION)) == Direction.UNDEFINED) {
            lgraph.setProperty(LayeredOptions.DIRECTION, LGraphUtil.getDirection(lgraph));
        }
        if ((randomSeed = (Integer)lgraph.getProperty(LayeredOptions.RANDOM_SEED)) == 0) {
            lgraph.setProperty(InternalProperties.RANDOM, new Random());
        } else {
            lgraph.setProperty(InternalProperties.RANDOM, new Random(randomSeed.intValue()));
        }
        Boolean favorStraightness = (Boolean)lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES);
        if (favorStraightness == null) {
            lgraph.setProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES, lgraph.getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL);
        }
        this.copyPortContraints(lgraph);
        Spacings spacings = new Spacings(lgraph);
        lgraph.setProperty(InternalProperties.SPACINGS, spacings);
    }

    private void copyPortContraints(LGraph lgraph) {
        lgraph.getLayerlessNodes().stream().forEach(lnode -> this.copyPortConstraints((LNode)((Object)lnode)));
        lgraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).forEach(lnode -> this.copyPortConstraints((LNode)((Object)lnode)));
    }

    private void copyPortConstraints(LNode node) {
        PortConstraints originalPortconstraints = (PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        node.setProperty(InternalProperties.ORIGINAL_PORT_CONSTRAINTS, originalPortconstraints);
        LGraph nestedGraph = node.getNestedGraph();
        if (nestedGraph != null) {
            this.copyPortContraints(nestedGraph);
        }
    }

    public void prepareGraphForLayout(LGraph lgraph) {
        this.configureGraphProperties(lgraph);
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutPhaseFactory)lgraph.getProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY));
        this.algorithmAssembler.setPhase((Enum)LayeredPhases.P2_LAYERING, (ILayoutPhaseFactory)lgraph.getProperty(LayeredOptions.LAYERING_STRATEGY));
        this.algorithmAssembler.setPhase((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutPhaseFactory)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY));
        this.algorithmAssembler.setPhase((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutPhaseFactory)lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY));
        this.algorithmAssembler.setPhase((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutPhaseFactory)EdgeRouterFactory.factoryFor((EdgeRouting)lgraph.getProperty(LayeredOptions.EDGE_ROUTING)));
        this.algorithmAssembler.addProcessorConfiguration(this.getPhaseIndependentLayoutProcessorConfiguration(lgraph));
        lgraph.setProperty(InternalProperties.PROCESSORS, this.algorithmAssembler.build((Object)lgraph));
    }

    private LayoutProcessorConfiguration<LayeredPhases, LGraph> getPhaseIndependentLayoutProcessorConfiguration(LGraph lgraph) {
        Set graphProperties = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        LayoutProcessorConfiguration configuration = LayoutProcessorConfiguration.createFrom(BASELINE_PROCESSING_CONFIGURATION);
        HierarchyHandling hierarchyHandling = (HierarchyHandling)lgraph.getProperty(LayeredOptions.HIERARCHY_HANDLING);
        if (hierarchyHandling == HierarchyHandling.INCLUDE_CHILDREN) {
            configuration.addAll(HIERARCHICAL_ADDITIONS);
        }
        if (((Boolean)lgraph.getProperty(LayeredOptions.FEEDBACK_EDGES)).booleanValue()) {
            configuration.addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        } else {
            configuration.addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        }
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) != null) {
            configuration.addAll(LABEL_MANAGEMENT_ADDITIONS);
        }
        if (((Boolean)lgraph.getProperty(LayeredOptions.INTERACTIVE_LAYOUT)).booleanValue()) {
            configuration.addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.CONSTRAINTS_POSTPROCESSOR);
        }
        switch ((Direction)lgraph.getProperty(LayeredOptions.DIRECTION)) {
            case LEFT: 
            case DOWN: 
            case UP: {
                configuration.addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.DIRECTION_PREPROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.DIRECTION_POSTPROCESSOR);
                break;
            }
        }
        if (graphProperties.contains((Object)GraphProperties.COMMENTS)) {
            configuration.addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.COMMENT_PREPROCESSOR).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.COMMENT_NODE_MARGIN_CALCULATOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.COMMENT_POSTPROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_STRATEGY) != NodePromotionStrategy.NONE) {
            configuration.addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.NODE_PROMOTION);
        }
        if (graphProperties.contains((Object)GraphProperties.PARTITIONS)) {
            configuration.addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.PARTITION_PREPROCESSOR);
            configuration.addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.PARTITION_POSTPROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_STRATEGY) != GraphCompactionStrategy.NONE && lgraph.getProperty(LayeredOptions.EDGE_ROUTING) != EdgeRouting.POLYLINE) {
            configuration.addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HORIZONTAL_COMPACTOR);
        }
        if (((Boolean)lgraph.getProperty(LayeredOptions.HIGH_DEGREE_NODES_TREATMENT)).booleanValue()) {
            configuration.addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HIGH_DEGREE_NODE_LAYER_PROCESSOR);
        }
        if (((Boolean)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_SEMI_INTERACTIVE)).booleanValue()) {
            configuration.addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.SEMI_INTERACTIVE_CROSSMIN_PROCESSOR);
        }
        if (GraphConfigurator.activateGreedySwitchFor(lgraph)) {
            GreedySwitchType greedySwitchType = (GreedySwitchType)((Object)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE));
            IntermediateProcessorStrategy internalGreedyType = greedySwitchType == GreedySwitchType.ONE_SIDED ? IntermediateProcessorStrategy.ONE_SIDED_GREEDY_SWITCH : IntermediateProcessorStrategy.TWO_SIDED_GREEDY_SWITCH;
            configuration.addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)internalGreedyType);
        }
        switch ((WrappingStrategy)((Object)lgraph.getProperty(LayeredOptions.WRAPPING_STRATEGY))) {
            case SINGLE_EDGE: {
                configuration.addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.SINGLE_EDGE_GRAPH_WRAPPER);
                break;
            }
            case MULTI_EDGE: {
                configuration.addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.BREAKING_POINT_INSERTER).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.BREAKING_POINT_PROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.BREAKING_POINT_REMOVER);
            }
        }
        return configuration;
    }

    public static boolean activateGreedySwitchFor(LGraph lgraph) {
        GreedySwitchType greedySwitchType = (GreedySwitchType)((Object)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE));
        boolean interactiveCrossMin = (Boolean)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_SEMI_INTERACTIVE) != false || lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY) == CrossingMinimizationStrategy.INTERACTIVE;
        int activationThreshold = (Integer)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_ACTIVATION_THRESHOLD);
        int graphSize = lgraph.getLayerlessNodes().size();
        return !interactiveCrossMin && greedySwitchType != GreedySwitchType.OFF && (activationThreshold == 0 || activationThreshold > graphSize);
    }
}

