/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.navigator.project.ProjectNavigatorView;

public class CloudExplorerUtils {
    public static List<DBNDataSource> getDataSourceNodes(List<DBPDataSourceContainer> dsList) {
        ArrayList<DBNDataSource> nodes = new ArrayList<DBNDataSource>();
        for (DBPDataSourceContainer ds : dsList) {
            DBNDataSource dsNode;
            DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(ds.getProject());
            if (projectNode == null || (dsNode = projectNode.getDatabases().getDataSource(ds)) == null) continue;
            nodes.add(dsNode);
        }
        return nodes;
    }

    public static void showNodeInNavigator(DBNDatabaseNode dsNode) {
        NavigatorViewBase nodeView;
        IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
        try {
            if (dsNode.getOwnerProject() == DBWorkbench.getPlatform().getWorkspace().getActiveProject()) {
                nodeView = (NavigatorViewBase)UIUtils.findView((IWorkbenchWindow)workbenchWindow, DatabaseNavigatorView.class);
                if (nodeView == null) {
                    nodeView = (NavigatorViewBase)workbenchWindow.getActivePage().showView("org.jkiss.dbeaver.core.databaseNavigator");
                }
            } else {
                nodeView = (NavigatorViewBase)UIUtils.findView((IWorkbenchWindow)workbenchWindow, ProjectNavigatorView.class);
                if (nodeView == null) {
                    nodeView = (NavigatorViewBase)workbenchWindow.getActivePage().showView("org.jkiss.dbeaver.core.projectNavigator");
                }
            }
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError("Can't open view", "Error opening navigator view", (Throwable)e);
            return;
        }
        if (nodeView != null) {
            if (!workbenchWindow.getActivePage().isPartVisible((IWorkbenchPart)nodeView)) {
                workbenchWindow.getActivePage().bringToTop((IWorkbenchPart)nodeView);
            }
            nodeView.showNode((DBNNode)dsNode);
        }
    }
}

