/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.model.navigator.DBNCloudDataSourceNode;
import com.dbeaver.cloud.model.navigator.DBNCloudDatabaseInstanceNode;
import com.dbeaver.cloud.model.navigator.DBNCloudNode;
import com.dbeaver.cloud.model.navigator.DBNCloudsRootNode;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationEditDialog;
import com.dbeaver.cloud.ui.explorer.CloudExplorerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.ui.dialogs.connection.ProjectSelectorPanel;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorLabelProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsTreeManager;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class CloudExplorerDialog
extends AbstractPopupPanel {
    private static final Log log = Log.getLog(CloudExplorerDialog.class);
    private static final String PREF_LAST_USED_CONFIGURATION = "cloud.explorer.last.configuration.id";
    private DatabaseNavigatorTree explorerTree;
    private ProjectSelectorPanel projectSelector;
    private Combo configurationsCombo;
    private List<CloudConfigurationDescriptor> allCloudConfigurations = new ArrayList<CloudConfigurationDescriptor>();
    private CloudConfigurationDescriptor currentCloudConfiguration;
    private Button addConnectionsButton;
    private transient Map<String, DBPDataSourceContainer> allInstances;

    public CloudExplorerDialog(Shell parent) {
        super(parent, "Cloud Explorer");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)CloudExplorerDialog.class.getSimpleName());
    }

    protected Control createDialogArea(Composite parent) {
        Composite group = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 600;
        group.setLayoutData((Object)gd);
        this.createCloudSelector(group);
        this.createCloudBrowser(group);
        this.refreshClouds(true);
        return group;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    private void createCloudSelector(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(768));
        Composite profileSelectorPanel = UIUtils.createComposite((Composite)composite, (int)2);
        profileSelectorPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)profileSelectorPanel, (String)"Cloud");
        this.configurationsCombo = new Combo(profileSelectorPanel, 2060);
        this.configurationsCombo.setLayoutData((Object)new GridData(768));
        this.configurationsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudConfigurationDescriptor item = (CloudConfigurationDescriptor)CloudExplorerDialog.this.allCloudConfigurations.get(CloudExplorerDialog.this.configurationsCombo.getSelectionIndex());
                if (item != null) {
                    DBWorkbench.getPlatform().getPreferenceStore().setValue(CloudExplorerDialog.PREF_LAST_USED_CONFIGURATION, item.getConfiguration().getCloudId());
                }
                CloudExplorerDialog.this.refreshClouds(false);
            }
        });
        this.loadConfigurations();
        this.closeOnFocusLost(new Control[]{this.configurationsCombo});
        this.closeOnFocusLost(this.configurationsCombo.getChildren());
        if (RuntimeUtils.isMacOS()) {
            UIUtils.asyncExec(() -> ((Composite)profileSelectorPanel).layout());
        }
        Composite buttonsGroup = UIUtils.createComposite((Composite)composite, (int)2);
        Button editConfigButton = UIUtils.createDialogButton((Composite)buttonsGroup, (String)"Edit config", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudExplorerDialog.this.editConfig();
            }
        });
        this.closeOnFocusLost(new Control[]{editConfigButton});
        if (this.configurationsCombo.getItemCount() == 0) {
            CloudConfigurationEditDialog newConfigurationDialog = new CloudConfigurationEditDialog(this.getParentShell(), null, true);
            newConfigurationDialog.open();
            this.loadConfigurations();
        }
    }

    private void loadConfigurations() {
        this.configurationsCombo.removeAll();
        this.allCloudConfigurations.clear();
        String lastConfigId = DBWorkbench.getPlatform().getPreferenceStore().getString(PREF_LAST_USED_CONFIGURATION);
        for (CloudConfigurationDescriptor cloud : CloudConfigurationDescriptor.getAllCloudConfigurations()) {
            this.allCloudConfigurations.add(cloud);
            this.configurationsCombo.add(CommonUtils.notEmpty((String)cloud.getConfiguration().getCloudName()));
            if (lastConfigId == null || !lastConfigId.equals(cloud.getConfiguration().getCloudId())) continue;
            this.configurationsCombo.select(this.configurationsCombo.getItemCount() - 1);
        }
        if (this.configurationsCombo.getSelectionIndex() < 0 && this.configurationsCombo.getItemCount() > 0) {
            this.configurationsCombo.select(0);
        }
    }

    private void createCloudBrowser(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        DatabaseNavigatorTreeFilter navigatorFilter = new DatabaseNavigatorTreeFilter(){

            public boolean select(Object element) {
                return true;
            }

            public boolean filterFolders() {
                return false;
            }

            public boolean isLeafObject(Object object) {
                return object instanceof DBNDataSource;
            }

            public boolean filterObjectByPattern(Object object) {
                return object instanceof DBNCloudDataSourceNode;
            }
        };
        this.explorerTree = new DatabaseNavigatorTree(composite, (DBNNode)DBWorkbench.getPlatform().getNavigatorModel().getRoot(), 67618, false, (INavigatorFilter)navigatorFilter, "Enter a part of database name here"){

            @NotNull
            protected DatabaseNavigatorLabelProvider createLabelProvider(DatabaseNavigatorTree tree) {
                return new CloudExplorerLabelProvider(tree);
            }
        };
        this.explorerTree.setLayoutData((Object)new GridData(1808));
        this.explorerTree.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof DBNProject);
            }
        });
        NavigatorUtils.addDragAndDropSupport((Viewer)this.explorerTree.getViewer(), (boolean)true, (boolean)false);
        CheckboxTreeViewer viewer = this.explorerTree.getCheckboxViewer();
        new DatabaseObjectsTreeManager(UIUtils.getDefaultRunnableContext(), viewer, new Class[]{DBNCloudDataSourceNode.class, DBNCloudDatabaseInstanceNode.class});
        viewer.addCheckStateListener(event -> this.addConnectionsButton.setEnabled(viewer.getCheckedElements().length > 0));
        Tree treeControl = this.explorerTree.getViewer().getTree();
        treeControl.setHeaderVisible(true);
        treeControl.addPaintListener(e -> {
            if (treeControl.getItemCount() == 0) {
                UIUtils.drawMessageOverControl((Control)treeControl, (PaintEvent)e, (String)"Choose cloud profile to browse databases", (int)0);
            }
        });
        this.createColumns(this.explorerTree.getViewer());
        UIUtils.setControlContextMenu((Control)treeControl, manager -> {
            DBNNode selectedNode = NavigatorUtils.getSelectedNode((ISelectionProvider)this.explorerTree.getViewer());
            if (selectedNode instanceof DBNCloudDataSourceNode) {
                DBPDataSourceContainer ds = this.getExistingDataSource((DBNCloudDataSourceNode)selectedNode);
                if (ds != null) {
                    manager.add((IAction)new ShowDataSourceAction(ds));
                } else {
                    manager.add((IAction)new AddDataSourceAction((DBNCloudDataSourceNode)selectedNode));
                }
                manager.add((IContributionItem)new Separator());
            }
            UIUtils.fillDefaultTreeContextMenu((IContributionManager)manager, (Tree)treeControl);
        });
        this.closeOnFocusLost(new Control[]{this.explorerTree, this.explorerTree.getViewer().getControl()});
        Composite buttonsGroup = UIUtils.createComposite((Composite)composite, (int)3);
        buttonsGroup.setLayoutData((Object)new GridData(768));
        this.projectSelector = new ProjectSelectorPanel(buttonsGroup, NavigatorUtils.getSelectedProject(), 1){

            protected void onProjectChange() {
                CloudExplorerDialog.this.allInstances = null;
                CloudExplorerDialog.this.explorerTree.getViewer().refresh();
            }
        };
        UIUtils.createEmptyLabel((Composite)buttonsGroup, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        this.addConnectionsButton = UIUtils.createDialogButton((Composite)buttonsGroup, (String)"Add to project", (DBPImage)UIIcon.SQL_NEW_CONNECTION, (String)"Add selected connections to the project", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudExplorerDialog.this.addSelectedToProject();
            }
        });
        this.addConnectionsButton.setEnabled(false);
    }

    private void createColumns(TreeViewer viewer) {
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        ViewerColumnController columnController = new ViewerColumnController("projectExplorer", (ColumnViewer)viewer);
        columnController.setForceAutoSize(true);
        columnController.addColumn("Name", "Resource name", 16384, true, true, (CellLabelProvider)new CloudExplorerLabelProvider(this, this.explorerTree){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        columnController.addColumn("Region", "Cloud region with resource", 16384, true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof DBNCloudDataSourceNode) {
                    return ((DBNCloudDataSourceNode)element).getInstance().getZone().getName();
                }
                return null;
            }
        });
        UIUtils.asyncExec(() -> columnController.createColumns(true));
    }

    private void refreshClouds(boolean forceRefresh) {
        if (!this.allCloudConfigurations.isEmpty()) {
            this.currentCloudConfiguration = this.allCloudConfigurations.get(this.configurationsCombo.getSelectionIndex());
        }
        DBPProject project = NavigatorUtils.getSelectedProject();
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project);
        DBNCloudsRootNode cloudRootNode = (DBNCloudsRootNode)projectNode.getExtraNode(DBNCloudsRootNode.class);
        if (cloudRootNode != null) {
            if (forceRefresh) {
                cloudRootNode.refreshCloudList();
            }
            DBNCloudNode[] cloudNodes = cloudRootNode.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            DBNCloudNode curNode = null;
            DBNCloudNode[] dBNCloudNodeArray = cloudNodes;
            int n = cloudNodes.length;
            int n2 = 0;
            while (n2 < n) {
                DBNCloudNode cn = dBNCloudNodeArray[n2];
                if (cn.getCloud().getCloudId().equals(this.currentCloudConfiguration.getConfiguration().getCloudId())) {
                    curNode = cn;
                    break;
                }
                ++n2;
            }
            DBNCloudNode selectedCloudNode = curNode;
            if (selectedCloudNode != null) {
                this.explorerTree.setInput(selectedCloudNode);
            }
        }
    }

    private void editConfig() {
        CloudConfigurationEditDialog manageDialog = new CloudConfigurationEditDialog(this.getShell(), this.currentCloudConfiguration, true);
        if (manageDialog.open() == 0) {
            CloudConfigurationDescriptor cloudConfig = manageDialog.getCurrentCloudConfig();
            this.loadConfigurations();
            int i = 0;
            while (i < this.allCloudConfigurations.size()) {
                if (this.allCloudConfigurations.get(i).equals(cloudConfig)) {
                    this.configurationsCombo.select(i);
                    break;
                }
                ++i;
            }
            this.refreshClouds(true);
        }
    }

    private void addSelectedToProject() {
        ArrayList<DBNCloudDataSourceNode> dsNodes = new ArrayList<DBNCloudDataSourceNode>();
        Object[] objectArray = this.explorerTree.getCheckboxViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DBNCloudDataSourceNode) {
                dsNodes.add((DBNCloudDataSourceNode)element);
            }
            ++n2;
        }
        if (!dsNodes.isEmpty()) {
            this.addNodesToProject(dsNodes);
            this.explorerTree.getCheckboxViewer().setCheckedElements(new Object[0]);
        }
    }

    private List<DBPDataSourceContainer> addNodesToProject(List<DBNCloudDataSourceNode> dsNodes) {
        if (!dsNodes.isEmpty()) {
            try {
                List<DBNDataSource> nodes;
                this.allInstances = null;
                List dsList = CPCloudUtils.createDataSourcesFromCloudNodes((DBPProject)this.projectSelector.getSelectedProject(), null, dsNodes);
                if (!dsList.isEmpty() && !(nodes = CloudExplorerUtils.getDataSourceNodes(dsList)).isEmpty()) {
                    DBNDataSource dsNode = nodes.get(0);
                    this.setModeless(false);
                    try {
                        CloudExplorerUtils.showNodeInNavigator((DBNDatabaseNode)dsNode);
                    }
                    finally {
                        this.setModeless(true);
                    }
                }
                this.explorerTree.getViewer().refresh();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error adding connections", "Error while creating connections from cloud explorer", (Throwable)e);
            }
        }
        return null;
    }

    private DBPDataSourceContainer getExistingDataSource(DBNCloudDataSourceNode element) {
        CPDatabaseInstance instance = element.getInstance();
        String instanceId = instance.getCloudResourceId();
        if (!CommonUtils.isEmpty((String)instanceId)) {
            return this.getCreatedInstances().get(instanceId);
        }
        return null;
    }

    private Map<String, DBPDataSourceContainer> getCreatedInstances() {
        if (this.allInstances == null) {
            this.allInstances = new HashMap<String, DBPDataSourceContainer>();
            for (DBPDataSourceContainer ds : this.projectSelector.getSelectedProject().getDataSourceRegistry().getDataSources()) {
                DBPDataSourceOrigin origin;
                if (ds.isHidden() || !((origin = ds.getOrigin()) instanceof DataSourceOriginCloud)) continue;
                String resourceId = ((DataSourceOriginCloud)origin).getResourceId();
                this.allInstances.put(resourceId, ds);
            }
        }
        return this.allInstances;
    }

    private class AddDataSourceAction
    extends Action {
        private final DBNCloudDataSourceNode node;

        AddDataSourceAction(DBNCloudDataSourceNode node) {
            super("Add '" + node.getNodeName() + "' to project");
            this.node = node;
        }

        public void run() {
            CloudExplorerDialog.this.addNodesToProject(Collections.singletonList(this.node));
        }
    }

    private class CloudExplorerLabelProvider
    extends DatabaseNavigatorLabelProvider {
        CloudExplorerLabelProvider(DatabaseNavigatorTree tree) {
            super((Viewer)tree.getViewer());
        }

        public Color getForeground(Object element) {
            if (element instanceof DBNCloudDataSourceNode && CloudExplorerDialog.this.getExistingDataSource((DBNCloudDataSourceNode)element) != null) {
                return CloudExplorerDialog.this.explorerTree.getViewer().getControl().getDisplay().getSystemColor(18);
            }
            return super.getForeground(element);
        }
    }

    private static class ShowDataSourceAction
    extends Action {
        private final DBPDataSourceContainer dataSource;

        ShowDataSourceAction(DBPDataSourceContainer dataSource) {
            super("Show in database navigator");
            this.dataSource = dataSource;
        }

        public void run() {
            DBNDatabaseNode dsNode = DBNUtils.getNodeByObject((DBSObject)this.dataSource);
            if (dsNode == null) {
                return;
            }
            CloudExplorerUtils.showNodeInNavigator(dsNode);
            super.run();
        }
    }
}

