/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationProviderCustom;
import com.dbeaver.cloud.registry.CloudConfigurationEditorDescriptor;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.cloud.registry.CloudUIRegistry;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import com.dbeaver.cloud.ui.explorer.CloudExplorerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectDelete;
import org.jkiss.utils.CommonUtils;

public class CloudConfigurationEditPage
extends DialogPage {
    private Combo cloudCombo;
    private Text configurationNameText;
    private Composite editorPlaceholder;
    private List<CloudConfigurationDescriptor> allCloudConfigurations = new ArrayList<CloudConfigurationDescriptor>();
    private CloudConfigurationDescriptor currentCloudConfig;
    private IObjectPropertyConfigurator<CPCloudConfiguration> editorInstance;
    private Runnable propChangeListener;
    private boolean showCloudSelector = true;

    public CloudConfigurationDescriptor getCurrentCloudConfig() {
        return this.currentCloudConfig;
    }

    public void setConfiguration(CloudConfigurationDescriptor currentCloudConfig) {
        this.currentCloudConfig = currentCloudConfig;
    }

    public void setShowCloudSelector(boolean showCloudSelector) {
        this.showCloudSelector = showCloudSelector;
    }

    public void setPropChangeListener(Runnable propChangeListener) {
        this.propChangeListener = propChangeListener;
    }

    public void createControl(Composite parent) {
        this.createCloudEditGroup(parent);
    }

    private void createCloudEditGroup(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 600;
        composite.setLayoutData((Object)gd);
        ((GridData)UIUtils.createControlLabel((Composite)composite, (String)"Configuration").getLayoutData()).horizontalSpan = 2;
        if (this.showCloudSelector) {
            Composite selectorGroup = UIUtils.createComposite((Composite)composite, (int)2);
            selectorGroup.setLayoutData((Object)new GridData(768));
            this.cloudCombo = new Combo(selectorGroup, 2060);
            this.cloudCombo.setLayoutData((Object)new GridData(768));
            ToolBar buttonsBar = new ToolBar(selectorGroup, 256);
            UIUtils.createToolItem((ToolBar)buttonsBar, (String)"Add cloud configuration", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CloudProviderDescriptor cloudProvider = CloudConfigurationEditPage.getActiveCloudProvider();
                    CPCloudConfigurationProviderCustom cfgProvider = CloudConfigurationEditPage.getCloudConfigurationProvider(CloudConfigurationEditPage.this.currentCloudConfig);
                    if (cloudProvider != null && cfgProvider != null) {
                        CloudConfigurationDescriptor newConfiguration = CloudConfigurationEditPage.this.createCloudConfiguration(cloudProvider, cfgProvider);
                        String configurationName = EnterNameDialog.chooseName((Shell)CloudConfigurationEditPage.this.getShell(), (String)"Configuration name", (String)newConfiguration.getConfiguration().getCloudName());
                        if (CommonUtils.isEmpty((String)configurationName)) {
                            return;
                        }
                        CloudConfigurationEditPage.this.saveConfigurationFromUI();
                        CloudConfigurationEditPage.this.currentCloudConfig = newConfiguration;
                        CloudConfigurationEditPage.this.currentCloudConfig.getConfiguration().setCloudName(configurationName);
                        CloudConfigurationEditPage.this.allCloudConfigurations.add(CloudConfigurationEditPage.this.currentCloudConfig);
                        CloudConfigurationEditPage.this.cloudCombo.add(CommonUtils.notEmpty((String)CloudConfigurationEditPage.this.currentCloudConfig.getConfiguration().getCloudName()));
                        CloudConfigurationEditPage.this.cloudCombo.select(CloudConfigurationEditPage.this.cloudCombo.getItemCount() - 1);
                        CloudConfigurationEditPage.this.showCloudConfiguration();
                    }
                }
            });
            final ToolItem removeButton = UIUtils.createToolItem((ToolBar)buttonsBar, (String)"Delete cloud configuration", (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CPCloudConfigurationProvider ccProvider;
                    if (CloudConfigurationEditPage.this.currentCloudConfig == null) {
                        return;
                    }
                    ArrayList<DBPDataSourceContainer> dsList = new ArrayList<DBPDataSourceContainer>();
                    for (DBPDataSourceContainer ds : DataSourceRegistry.getAllDataSources()) {
                        if (ds.isHidden() || !(ds.getOrigin() instanceof DataSourceOriginCloud) || !ds.getOrigin().getDisplayName().equals(CloudConfigurationEditPage.this.currentCloudConfig.getConfiguration().getCloudName())) continue;
                        dsList.add(ds);
                    }
                    if (!dsList.isEmpty()) {
                        if (!UIUtils.confirmAction((String)"Cannot delete configuration", (String)("Cloud configuration '" + CloudConfigurationEditPage.this.currentCloudConfig.getConfiguration().getCloudName() + "' is used to connect to  " + dsList.size() + " datasource(s)." + "\nDo you want to view and delete these connections?\n"))) {
                            return;
                        }
                        List<DBNDataSource> dataSourceNodes = CloudExplorerUtils.getDataSourceNodes(dsList);
                        if (!NavigatorHandlerObjectDelete.tryDeleteObjects((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (IStructuredSelection)new StructuredSelection(dataSourceNodes))) {
                            return;
                        }
                    } else if (!UIUtils.confirmAction((Shell)CloudConfigurationEditPage.this.getShell(), (String)"Confirm configuration delete", (String)("Are you sure you want to delete cloud configuration '" + CloudConfigurationEditPage.this.currentCloudConfig.getConfiguration().getCloudName() + "'?"))) {
                        return;
                    }
                    if (!((ccProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(CloudConfigurationEditPage.this.currentCloudConfig.getCloudProvider().getId())) instanceof CPCloudConfigurationProviderCustom)) {
                        DBWorkbench.getPlatformUI().showError("Bad cloud configuration provider", "Cloud configuration provider doesn't support custom clouds");
                        return;
                    }
                    int curConfigIndex = CloudConfigurationEditPage.this.allCloudConfigurations.indexOf(CloudConfigurationEditPage.this.currentCloudConfig);
                    if (curConfigIndex >= 0) {
                        CloudConfigurationEditPage.this.cloudCombo.remove(curConfigIndex);
                        CloudConfigurationEditPage.this.allCloudConfigurations.remove(curConfigIndex);
                        if (curConfigIndex >= CloudConfigurationEditPage.this.allCloudConfigurations.size() - 1 && curConfigIndex > 0) {
                            --curConfigIndex;
                        }
                        CloudConfigurationEditPage.this.currentCloudConfig = curConfigIndex < CloudConfigurationEditPage.this.allCloudConfigurations.size() ? (CloudConfigurationDescriptor)CloudConfigurationEditPage.this.allCloudConfigurations.get(curConfigIndex) : null;
                        CloudConfigurationEditPage.this.showCloudConfiguration();
                        CloudConfigurationEditPage.this.saveConfigurations();
                    }
                }
            });
            this.cloudCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int cloudIndex = CloudConfigurationEditPage.this.cloudCombo.getSelectionIndex();
                    if (cloudIndex < 0) {
                        return;
                    }
                    if (CloudConfigurationEditPage.this.currentCloudConfig == CloudConfigurationEditPage.this.allCloudConfigurations.get(cloudIndex)) {
                        return;
                    }
                    CloudConfigurationEditPage.this.saveConfigurationFromUI();
                    CloudConfigurationEditPage.this.currentCloudConfig = (CloudConfigurationDescriptor)CloudConfigurationEditPage.this.allCloudConfigurations.get(cloudIndex);
                    removeButton.setEnabled(CloudConfigurationEditPage.this.currentCloudConfig != null);
                    CloudConfigurationEditPage.this.showCloudConfiguration();
                    if (CloudConfigurationEditPage.this.propChangeListener != null) {
                        CloudConfigurationEditPage.this.propChangeListener.run();
                    }
                }
            });
        }
        this.configurationNameText = UIUtils.createLabelText((Composite)composite, (String)"Name", null, (int)2048);
        if (!this.showCloudSelector) {
            this.configurationNameText.setEnabled(false);
        } else {
            this.configurationNameText.addModifyListener(e -> {
                if (this.currentCloudConfig != null) {
                    this.currentCloudConfig.getConfiguration().setCloudName(this.configurationNameText.getText());
                    this.cloudCombo.select(this.allCloudConfigurations.indexOf(this.currentCloudConfig));
                }
                if (this.propChangeListener != null) {
                    this.propChangeListener.run();
                }
            });
        }
        this.editorPlaceholder = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.editorPlaceholder.setLayoutData((Object)gd);
        this.editorPlaceholder.setLayout((Layout)new FillLayout());
        this.resetToDefaults();
        this.setControl((Control)composite);
    }

    void resetToDefaults() {
        if (this.showCloudSelector) {
            this.cloudCombo.removeAll();
            this.allCloudConfigurations.clear();
            for (CloudConfigurationDescriptor ccd : CloudConfigurationDescriptor.getAllCloudConfigurations()) {
                this.allCloudConfigurations.add(ccd);
                this.cloudCombo.add(CommonUtils.notEmpty((String)ccd.getConfiguration().getCloudName()));
            }
        }
        this.showCloudConfiguration();
        if (this.propChangeListener != null) {
            this.propChangeListener.run();
        }
    }

    private CloudConfigurationDescriptor createCloudConfiguration(CloudProviderDescriptor cloudProvider, CPCloudConfigurationProviderCustom<?> cfgProvider) {
        CloudConfigurationDescriptor cfg = new CloudConfigurationDescriptor(cloudProvider, cfgProvider.createConfiguration());
        cfg.getConfiguration().setCloudId(UUID.randomUUID().toString());
        cfg.getConfiguration().setCloudName(this.generateCloudName(cfg));
        return cfg;
    }

    @NotNull
    public String generateCloudName(CloudConfigurationDescriptor cfg) {
        int i = 0;
        while (true) {
            String name = String.valueOf(cfg.getCloudProvider().getLabel()) + " configuration";
            if (i > 0) {
                name = String.valueOf(name) + " (" + i + ")";
            }
            for (CloudConfigurationDescriptor ccd : this.allCloudConfigurations) {
                if (!name.equals(ccd.getConfiguration().getCloudName())) continue;
                name = null;
                break;
            }
            if (name != null) {
                return name;
            }
            ++i;
        }
    }

    private void showCloudConfiguration() {
        UIUtils.disposeChildControls((Composite)this.editorPlaceholder);
        if (this.currentCloudConfig == null) {
            CloudProviderDescriptor cloudProvider = CloudConfigurationEditPage.getActiveCloudProvider();
            CPCloudConfigurationProviderCustom<?> cfgProvider = CloudConfigurationEditPage.getCloudConfigurationProvider(null);
            if (cloudProvider != null && cfgProvider != null) {
                this.currentCloudConfig = this.createCloudConfiguration(cloudProvider, cfgProvider);
                this.allCloudConfigurations.add(this.currentCloudConfig);
                this.cloudCombo.add(CommonUtils.notEmpty((String)this.currentCloudConfig.getConfiguration().getCloudName()));
                this.cloudCombo.select(this.cloudCombo.getItemCount() - 1);
            }
        }
        if (this.currentCloudConfig == null) {
            return;
        }
        this.configurationNameText.setEnabled(this.showCloudSelector);
        this.configurationNameText.setText(CommonUtils.notEmpty((String)this.currentCloudConfig.getConfiguration().getCloudName()));
        CloudConfigurationEditorDescriptor cloudEditorDescriptor = CloudUIRegistry.getInstance().getConfigurationEditor(this.currentCloudConfig.getCloudProvider());
        if (cloudEditorDescriptor == null) {
            DBWorkbench.getPlatformUI().showError("No cloud configuration editor", "No configuration editor for cloud '" + this.currentCloudConfig.getCloudProvider().getId() + "'");
            return;
        }
        try {
            this.editorInstance = cloudEditorDescriptor.createInstance();
            this.editorInstance.createControl(this.editorPlaceholder, this.propChangeListener);
            this.editorInstance.loadSettings((Object)this.currentCloudConfig.getConfiguration());
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Editor error", "Error while creating configuration editor", (Throwable)e);
            return;
        }
    }

    private void saveConfigurationFromUI() {
        if (this.currentCloudConfig != null && this.editorInstance != null && this.editorInstance.isComplete() && this.currentCloudConfig != null) {
            CPCloudConfiguration cfg = this.currentCloudConfig.getConfiguration();
            cfg.setCloudName(this.configurationNameText.getText());
            this.editorInstance.saveSettings((Object)cfg);
        }
    }

    private static CPCloudConfigurationProviderCustom<?> getCloudConfigurationProvider(CloudConfigurationDescriptor config) {
        CPCloudConfigurationProvider ccProvider;
        if (config == null) {
            CloudProviderDescriptor cloudProvider = CloudConfigurationEditPage.getActiveCloudProvider();
            if (cloudProvider == null) {
                return null;
            }
            ccProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(cloudProvider.getId());
            if (ccProvider == null) {
                DBWorkbench.getPlatformUI().showError("Invalid configuration provider", "Error creating cloud configuration provider");
                return null;
            }
        } else {
            ccProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(config.getCloudProvider().getId());
        }
        if (!(ccProvider instanceof CPCloudConfigurationProviderCustom)) {
            DBWorkbench.getPlatformUI().showError("Bad cloud configuration provider", "Cloud configuration provider doesn't support custom clouds");
            return null;
        }
        return (CPCloudConfigurationProviderCustom)ccProvider;
    }

    private static CloudProviderDescriptor getActiveCloudProvider() {
        List cloudProviders = CloudProviderRegistry.getInstance().getCloudProviders();
        if (cloudProviders.isEmpty()) {
            DBWorkbench.getPlatformUI().showError("No cloud configuration provider", "No cloud configuration providers found");
            return null;
        }
        return (CloudProviderDescriptor)cloudProviders.get(0);
    }

    public void saveConfigurations() {
        List<CloudConfigurationDescriptor> configurations;
        this.saveConfigurationFromUI();
        if (this.showCloudSelector) {
            configurations = this.allCloudConfigurations;
        } else {
            configurations = new ArrayList<CloudConfigurationDescriptor>(CloudConfigurationDescriptor.getAllCloudConfigurations());
            int i = 0;
            while (i < configurations.size()) {
                if (configurations.get(i).equals(this.currentCloudConfig)) {
                    configurations.set(i, this.currentCloudConfig);
                }
                ++i;
            }
        }
        LinkedHashMap<CPCloudConfigurationProviderCustom, List> configMap = new LinkedHashMap<CPCloudConfigurationProviderCustom, List>();
        for (CloudConfigurationDescriptor ccd : configurations) {
            CPCloudConfigurationProviderCustom<?> ccp = CloudConfigurationEditPage.getCloudConfigurationProvider(ccd);
            if (ccp == null) continue;
            configMap.computeIfAbsent(ccp, c -> new ArrayList()).add(ccd.getConfiguration());
        }
        for (CPCloudConfigurationProviderCustom ccpc : configMap.keySet()) {
            List list = (List)configMap.get(ccpc);
            ccpc.saveConfigurations((Collection)list);
        }
    }

    public boolean isComplete() {
        return this.editorInstance != null && this.editorInstance.isComplete();
    }
}

