/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.explorer;

import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.utils.CommonUtils;

public class CloudConfigurationDescriptor {
    private CloudProviderDescriptor cloudProvider;
    private CPCloudConfiguration configuration;

    public CloudConfigurationDescriptor(CloudProviderDescriptor cloudProvider, CPCloudConfiguration configuration) {
        this.cloudProvider = cloudProvider;
        this.configuration = configuration;
    }

    public CloudProviderDescriptor getCloudProvider() {
        return this.cloudProvider;
    }

    public CPCloudConfiguration getConfiguration() {
        return this.configuration;
    }

    public static List<CloudConfigurationDescriptor> getAllCloudConfigurations() {
        ArrayList<CloudConfigurationDescriptor> profiles = new ArrayList<CloudConfigurationDescriptor>();
        for (CloudProviderDescriptor cpDescriptor : CloudProviderRegistry.getInstance().getCloudProviders()) {
            CPCloudConfigurationProvider configurationProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(cpDescriptor.getId());
            if (configurationProvider == null) continue;
            CPCloudConfiguration[] cPCloudConfigurationArray = configurationProvider.getCloudConfigurations();
            int n = cPCloudConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                CPCloudConfiguration cloudConfig = cPCloudConfigurationArray[n2];
                profiles.add(new CloudConfigurationDescriptor(cpDescriptor, cloudConfig));
                ++n2;
            }
        }
        return profiles;
    }

    public boolean equals(Object obj) {
        return obj instanceof CloudConfigurationDescriptor && this.configuration.getCloudId() != null && CommonUtils.equalObjects((Object)this.configuration.getCloudId(), (Object)((CloudConfigurationDescriptor)obj).getConfiguration().getCloudId());
    }

    public int hashCode() {
        return this.configuration.getCloudId() == null ? super.hashCode() : this.configuration.getCloudId().hashCode();
    }
}

