/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.connection;

import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationEditDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomFormEditor;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

class CloudConnectionPage
extends ActiveWizardPage
implements IDataSourceConnectionEditor {
    private IDataSourceConnectionEditorSite site;
    private DataSourceOriginCloud<?, ?> cloudOrigin;
    private transient boolean propsLoaded;
    private Composite propsGroup;

    CloudConnectionPage() {
        super(CloudConnectionPage.class.getSimpleName());
    }

    public void setSite(IDataSourceConnectionEditorSite site) {
        this.site = site;
    }

    public void createControl(Composite composite) {
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        this.cloudOrigin = (DataSourceOriginCloud)dataSource.getOrigin();
        this.setTitle(this.cloudOrigin.getCloudProvider().getLabel());
        this.propsGroup = new Composite(composite, 0);
        this.propsGroup.setLayout((Layout)new GridLayout(2, false));
        UIUtils.createLabelText((Composite)this.propsGroup, (String)"Cloud", (String)this.cloudOrigin.getCloudProvider().getLabel(), (int)2056);
        UIUtils.createControlLabel((Composite)this.propsGroup, (String)"Configuration");
        Composite cfgInfoPanel = UIUtils.createComposite((Composite)this.propsGroup, (int)2);
        cfgInfoPanel.setLayoutData((Object)new GridData(768));
        Text cfgNameText = new Text(cfgInfoPanel, 2056);
        cfgNameText.setText(this.cloudOrigin.getCloud().getName());
        cfgNameText.setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)cfgInfoPanel, (String)"Configure", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudConfigurationDescriptor ccd = new CloudConfigurationDescriptor(CloudConnectionPage.this.cloudOrigin.getCloudProvider(), CloudConnectionPage.this.cloudOrigin.getCloud().getCloudConfiguration());
                CloudConfigurationEditDialog dialog = new CloudConfigurationEditDialog(CloudConnectionPage.this.getShell(), ccd, false);
                dialog.open();
            }
        });
        UIUtils.createHorizontalLine((Composite)this.propsGroup, (int)2, (int)0);
        UIUtils.createControlLabel((Composite)this.propsGroup, (String)"Properties", (int)2);
        this.setControl((Control)this.propsGroup);
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
    }

    public void activatePage() {
        if (this.propsLoaded) {
            return;
        }
        this.propsLoaded = true;
        UIUtils.asyncExec(this::loadCloudInfo);
    }

    public void loadCloudInfo() {
        try {
            this.site.getRunnableContext().run(true, true, monitor -> {
                monitor.beginTask("Load cloud information", 1);
                try {
                    try {
                        monitor.subTask("Load datasource details");
                        DBPObject objectDetails = this.cloudOrigin.getObjectDetails(monitor, DBWorkbench.getPlatform().getNavigatorModel().getModelAuthContext(), (Object)this.site.getActiveDataSource());
                        if (objectDetails != null) {
                            PropertyCollector originProps = new PropertyCollector((Object)objectDetails, true);
                            originProps.collectProperties();
                            UIUtils.asyncExec(() -> this.createPropertyForm(originProps));
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getTargetException().getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void createPropertyForm(PropertyCollector originProps) {
        CustomFormEditor formEditor = new CustomFormEditor((DBSObject)this.site.getActiveDataSource(), null, (DBPPropertySource)originProps);
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = originProps.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            formEditor.createPropertyEditor(this.propsGroup, prop);
            ++n2;
        }
        Composite buttonsPanel = UIUtils.createComposite((Composite)this.propsGroup, (int)2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttonsPanel.setLayoutData((Object)gd);
        UIUtils.createEmptyLabel((Composite)buttonsPanel, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        Button syncButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Sync", null, (String)"Update connection configuration from cloud", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        syncButton.setEnabled(false);
        this.propsGroup.layout(true, true);
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
    }
}

