/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;

public class ListAttachedGroupPoliciesIterable
implements SdkIterable<ListAttachedGroupPoliciesResponse> {
    private final IamClient client;
    private final ListAttachedGroupPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachedGroupPoliciesIterable(IamClient client, ListAttachedGroupPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachedGroupPoliciesResponseFetcher();
    }

    public Iterator<ListAttachedGroupPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedGroupPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedPolicies() != null) {
                return response.attachedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttachedGroupPoliciesResponseFetcher
    implements SyncPageFetcher<ListAttachedGroupPoliciesResponse> {
        private ListAttachedGroupPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedGroupPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAttachedGroupPoliciesResponse nextPage(ListAttachedGroupPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedGroupPoliciesIterable.this.client.listAttachedGroupPolicies(ListAttachedGroupPoliciesIterable.this.firstRequest);
            }
            return ListAttachedGroupPoliciesIterable.this.client.listAttachedGroupPolicies((ListAttachedGroupPoliciesRequest)((Object)ListAttachedGroupPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

