/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.ContextKeyNamesResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContextKeysForPrincipalPolicyResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetContextKeysForPrincipalPolicyResponse> {
    private static final SdkField<List<String>> CONTEXT_KEY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextKeyNames").getter(GetContextKeysForPrincipalPolicyResponse.getter(GetContextKeysForPrincipalPolicyResponse::contextKeyNames)).setter(GetContextKeysForPrincipalPolicyResponse.setter(Builder::contextKeyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_KEY_NAMES_FIELD));
    private final List<String> contextKeyNames;

    private GetContextKeysForPrincipalPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.contextKeyNames = builder.contextKeyNames;
    }

    public boolean hasContextKeyNames() {
        return this.contextKeyNames != null && !(this.contextKeyNames instanceof SdkAutoConstructList);
    }

    public List<String> contextKeyNames() {
        return this.contextKeyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contextKeyNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContextKeysForPrincipalPolicyResponse)) {
            return false;
        }
        GetContextKeysForPrincipalPolicyResponse other = (GetContextKeysForPrincipalPolicyResponse)((Object)obj);
        return Objects.equals(this.contextKeyNames(), other.contextKeyNames());
    }

    public String toString() {
        return ToString.builder((String)"GetContextKeysForPrincipalPolicyResponse").add("ContextKeyNames", this.contextKeyNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContextKeyNames": {
                return Optional.ofNullable(clazz.cast(this.contextKeyNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContextKeysForPrincipalPolicyResponse, T> g) {
        return obj -> g.apply((GetContextKeysForPrincipalPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<String> contextKeyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContextKeysForPrincipalPolicyResponse model) {
            super(model);
            this.contextKeyNames(model.contextKeyNames);
        }

        public final Collection<String> getContextKeyNames() {
            return this.contextKeyNames;
        }

        @Override
        public final Builder contextKeyNames(Collection<String> contextKeyNames) {
            this.contextKeyNames = ContextKeyNamesResultListTypeCopier.copy(contextKeyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeyNames(String ... contextKeyNames) {
            this.contextKeyNames(Arrays.asList(contextKeyNames));
            return this;
        }

        public final void setContextKeyNames(Collection<String> contextKeyNames) {
            this.contextKeyNames = ContextKeyNamesResultListTypeCopier.copy(contextKeyNames);
        }

        @Override
        public GetContextKeysForPrincipalPolicyResponse build() {
            return new GetContextKeysForPrincipalPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContextKeysForPrincipalPolicyResponse> {
        public Builder contextKeyNames(Collection<String> var1);

        public Builder contextKeyNames(String ... var1);
    }
}

