/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAccessKeyRequest
extends IamRequest
implements ToCopyableBuilder<Builder, DeleteAccessKeyRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(DeleteAccessKeyRequest.getter(DeleteAccessKeyRequest::userName)).setter(DeleteAccessKeyRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessKeyId").getter(DeleteAccessKeyRequest.getter(DeleteAccessKeyRequest::accessKeyId)).setter(DeleteAccessKeyRequest.setter(Builder::accessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, ACCESS_KEY_ID_FIELD));
    private final String userName;
    private final String accessKeyId;

    private DeleteAccessKeyRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.accessKeyId = builder.accessKeyId;
    }

    public String userName() {
        return this.userName;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccessKeyRequest)) {
            return false;
        }
        DeleteAccessKeyRequest other = (DeleteAccessKeyRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.accessKeyId(), other.accessKeyId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteAccessKeyRequest").add("UserName", (Object)this.userName()).add("AccessKeyId", (Object)this.accessKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "AccessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccessKeyRequest, T> g) {
        return obj -> g.apply((DeleteAccessKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String accessKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccessKeyRequest model) {
            super(model);
            this.userName(model.userName);
            this.accessKeyId(model.accessKeyId);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAccessKeyRequest build() {
            return new DeleteAccessKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAccessKeyRequest> {
        public Builder userName(String var1);

        public Builder accessKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

