/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskContext;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskSettings;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.model.task.DBTaskUtils;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.registry.TaskUIRegistry;
import org.jkiss.dbeaver.tasks.ui.wizard.EditTaskConfigurationDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.EditTaskVariablesDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageSettings;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageTask;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseWizard;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public abstract class TaskConfigurationWizard<SETTINGS extends DBTTaskSettings>
extends BaseWizard
implements IWorkbenchWizard {
    private static final Log log = Log.getLog(TaskConfigurationWizard.class);
    private static final String TASKS_VIEW_ID = "org.jkiss.dbeaver.tasks";
    private DBTTask currentTask;
    private IStructuredSelection currentSelection;
    private Button saveAsTaskButton;
    private Map<String, Object> variables;
    private DBTTaskContext taskContext;

    protected TaskConfigurationWizard() {
    }

    protected TaskConfigurationWizard(@Nullable DBTTask task) {
        this.currentTask = task;
    }

    protected abstract SETTINGS getSettings();

    protected abstract String getDefaultWindowTitle();

    public boolean isTaskEditor() {
        return this.currentTask != null;
    }

    public boolean isNewTaskEditor() {
        return this.currentTask != null && this.getProject().getTaskManager().getTaskById(this.currentTask.getId()) == null;
    }

    public abstract String getTaskTypeId();

    public abstract void saveTaskState(DBRRunnableContext var1, DBTTask var2, Map<String, Object> var3);

    public boolean isRunTaskOnFinish() {
        return this.getCurrentTask() != null && !this.getCurrentTask().isTemporary() && !this.getContainer().isSelectorMode();
    }

    public IStructuredSelection getCurrentSelection() {
        return this.currentSelection;
    }

    public DBTTask getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(DBTTask currentTask) {
        this.currentTask = currentTask;
        this.updateWizardTitle();
        this.getContainer().updateButtons();
    }

    public DBPProject getProject() {
        return this.currentTask != null ? this.currentTask.getProject() : NavigatorUtils.getSelectedProject();
    }

    public DBTTaskType getTaskType() {
        return TaskRegistry.getInstance().getTaskType(this.getTaskTypeId());
    }

    protected void updateWizardTitle() {
        String wizTitle = this.getDefaultWindowTitle();
        if (this.isTaskEditor()) {
            TaskConfigurationWizardPageTask taskPage = this.getContainer() == null ? null : this.getContainer().getTaskPage();
            wizTitle = String.valueOf(wizTitle) + " - [" + (taskPage == null ? this.currentTask.getName() : taskPage.getTaskName()) + "]";
        }
        this.setWindowTitle(wizTitle);
    }

    public TaskConfigurationWizardDialog getContainer() {
        return (TaskConfigurationWizardDialog)super.getContainer();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.updateWizardTitle();
        this.setNeedsProgressMonitor(true);
        this.currentSelection = currentSelection;
        this.getContainer().addPageChangedListener(event -> this.updateWizardTitle());
    }

    public void addPages() {
        super.addPages();
        this.addTaskConfigPages();
    }

    protected boolean isTaskConfigPage(IWizardPage page) {
        return page instanceof TaskConfigurationWizardPageTask || page instanceof TaskConfigurationWizardPageSettings;
    }

    protected void addTaskConfigPages() {
        if (this.isCurrentTaskSaved()) {
            this.addPage((IWizardPage)new TaskConfigurationWizardPageTask(this.getCurrentTask()));
            this.addPage((IWizardPage)new TaskConfigurationWizardPageSettings(this.getCurrentTask()));
        }
    }

    public boolean isCurrentTaskSaved() {
        return this.getCurrentTask() != null && this.getCurrentTask().getProject().getTaskManager().getTaskById(this.getCurrentTask().getId()) != null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage instanceof TaskConfigurationWizardPageSettings && page instanceof TaskConfigurationWizardPageTask && !TaskUIRegistry.getInstance().supportsConfiguratorPage(this.getContainer().getTaskPage().getSelectedTaskType())) {
            return this.getNextPage(nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage prevPage = super.getPreviousPage(page);
        if (prevPage instanceof TaskConfigurationWizardPageSettings && !TaskUIRegistry.getInstance().supportsConfiguratorPage(this.getContainer().getTaskPage().getSelectedTaskType())) {
            return this.getPreviousPage(prevPage);
        }
        return prevPage;
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (this.isPageValid(page) && !page.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        TaskConfigurationWizardPageTask taskPage = this.getContainer().getTaskPage();
        return taskPage == null || taskPage.isPageComplete();
    }

    public boolean performFinish() {
        if (this.currentTask != null && !this.currentTask.isTemporary()) {
            this.saveTask();
        }
        return !this.isRunTaskOnFinish() || this.runTask();
    }

    protected boolean runTask() {
        try {
            DBTTask task = this.getCurrentTask();
            if (task == null) {
                task = this.getProject().getTaskManager().createTemporaryTask(this.getTaskType(), this.getWindowTitle());
                this.saveConfigurationToTask(task);
            }
            TaskWizardExecutor executor = new TaskWizardExecutor(this.getRunnableContext(), task, log, System.out);
            if (this.getCurrentTask() == null) {
                executor.executeTask();
            } else {
                task.getProject().getTaskManager().runTask(task, (DBTTaskExecutionListener)executor, Collections.emptyMap());
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Task run error", e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean isPageValid(IWizardPage page) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveTask() {
        DBTTask currentTask = this.getCurrentTask();
        if (currentTask == null || currentTask.isTemporary()) {
            DBTTaskType taskType = this.getTaskType();
            if (taskType == null) {
                DBWorkbench.getPlatformUI().showError("No task type", "Can't find task type " + this.getTaskTypeId());
                return;
            }
            EditTaskConfigurationDialog dialog = new EditTaskConfigurationDialog(this.getContainer().getShell(), this.getProject(), taskType);
            if (dialog.open() != 0) return;
            currentTask = dialog.getTask();
            this.setCurrentTask(currentTask);
        } else {
            TaskConfigurationWizardPageTask taskPage = this.getContainer().getTaskPage();
            if (taskPage != null) {
                taskPage.saveSettings();
            }
        }
        DBTTask theTask = currentTask;
        this.saveConfigurationToTask(theTask);
    }

    protected void saveConfigurationToTask(DBTTask theTask) {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        this.saveTaskState(this.getRunnableContext(), theTask, state);
        DBTTaskContext context = this.getTaskContext();
        if (context != null) {
            DBTaskUtils.saveTaskContext(state, (DBTTaskContext)context);
        }
        if (theTask.getType().supportsVariables()) {
            DBTaskUtils.setVariables(state, this.getTaskVariables());
        }
        theTask.setProperties(state);
        try {
            theTask.getProject().getTaskManager().updateTaskConfiguration(theTask);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Task save error", "Error saving task configuration", (Throwable)e);
        }
    }

    public void createTaskSaveGroup(Composite parent) {
        Group taskGroup = UIUtils.createControlGroup((Composite)parent, (String)TaskUIMessages.task_config_wizard_group_task_label, (int)2, (int)34, (int)0);
        this.createTaskSaveButtons((Composite)taskGroup, false, 1);
    }

    public void createTaskSaveButtons(Composite parent, boolean horizontal, int hSpan) {
        IViewDescriptor tasksViewDescriptor = PlatformUI.getWorkbench().getViewRegistry().find(TASKS_VIEW_ID);
        if (tasksViewDescriptor == null || this.getContainer().isSelectorMode()) {
            UIUtils.createEmptyLabel((Composite)parent, (int)hSpan, (int)1);
        } else {
            Composite panel = new Composite(parent, 0);
            if (parent.getLayout() instanceof GridLayout) {
                GridData gd = new GridData(768);
                gd.horizontalSpan = hSpan;
                panel.setLayoutData((Object)gd);
            }
            boolean supportsVariables = this.getTaskType().supportsVariables();
            panel.setLayout((Layout)new GridLayout(horizontal ? (supportsVariables ? 3 : 2) : 1, false));
            if (supportsVariables) {
                UIUtils.createDialogButton((Composite)panel, (String)(String.valueOf(TaskUIMessages.task_config_wizard_button_variables) + " ..."), (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TaskConfigurationWizard.this.configureVariables();
                    }
                });
            }
            this.saveAsTaskButton = UIUtils.createDialogButton((Composite)panel, (String)TaskUIMessages.task_config_wizard_button_save_task, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskConfigurationWizard.this.saveTask();
                }
            });
            Link tasksLink = UIUtils.createLink((Composite)panel, (String)("<a>" + TaskUIMessages.task_config_wizard_link_open_tasks_view + "</a>"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        UIUtils.getActiveWorkbenchWindow().getActivePage().showView(TaskConfigurationWizard.TASKS_VIEW_ID);
                    }
                    catch (PartInitException e1) {
                        DBWorkbench.getPlatformUI().showError("Show view", "Error opening database tasks view", (Throwable)e1);
                    }
                }
            });
            tasksLink.setLayoutData((Object)new GridData(128));
        }
    }

    private void configureVariables() {
        Map<String, Object> variables = this.getTaskVariables();
        EditTaskVariablesDialog dialog = new EditTaskVariablesDialog(this.getContainer().getShell(), variables);
        if (dialog.open() == 0) {
            this.variables = dialog.getVariables();
        }
    }

    protected Map<String, Object> getTaskVariables() {
        if (this.variables == null) {
            this.variables = this.currentTask != null ? DBTaskUtils.getVariables((DBTTask)this.currentTask) : new LinkedHashMap<String, Object>();
        }
        return this.variables;
    }

    public DBTTaskContext getTaskContext() {
        if (this.taskContext == null && this.currentTask != null) {
            this.taskContext = DBTaskUtils.loadTaskContext((Map)this.currentTask.getProperties());
        }
        return this.taskContext;
    }

    protected void saveTaskContext(DBCExecutionContext executionContext) {
        this.taskContext = DBTaskUtils.extractContext((DBCExecutionContext)executionContext);
    }

    public void updateSaveTaskButtons() {
        if (this.saveAsTaskButton != null) {
            this.saveAsTaskButton.setEnabled(this.canFinish());
        }
    }

    public IWizardPage getStartingPage() {
        IWizardPage startingPage = super.getStartingPage();
        if (this.getContainer().isEditMode()) {
            return this.getNextPage(startingPage);
        }
        return startingPage;
    }
}

