/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResultQuery;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;

class SchemaMigration {
    private static final Log log = Log.getLog(SchemaMigration.class);
    private final CMPOptions options;
    private final CMPResultQuery[] resultQueries;

    public SchemaMigration(CMPOptions options, CMPResultQuery[] resultQueries) {
        this.options = options;
        this.resultQueries = resultQueries;
    }

    public void runMigration(DBRProgressMonitor monitor) throws CMPException {
        monitor.beginTask("Perform schema migration", this.resultQueries.length);
        monitor.subTask("Open session");
        DBPDataSource dataSource = this.options.getTargetInput().getDataSourceContainer().getDataSource();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Schema migration");){
                DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
                if (txnManager != null && txnManager.isSupportsTransactions() && txnManager.isAutoCommit()) {
                    try {
                        txnManager.setAutoCommit(session.getProgressMonitor(), false);
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
                try {
                    CMPResultQuery[] cMPResultQueryArray = this.resultQueries;
                    int n = this.resultQueries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CMPResultQuery query = cMPResultQueryArray[n2];
                        if (monitor.isCanceled()) break;
                        monitor.subTask(query.getChangeItem().getFullyQualifiedName(DBPEvaluationContext.UI));
                        String trimmedQuery = SQLUtils.removeQueryDelimiter((SQLDialect)dataSource.getSQLDialect(), (String)query.getQuery());
                        try {
                            Throwable throwable2 = null;
                            Object var13_19 = null;
                            try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.SCRIPT, trimmedQuery, false, false, false);){
                                dbStat.executeStatement();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (DBCException e) {
                            DBPPlatformUI.UserResponse userResponse = DBWorkbench.getPlatformUI().showErrorStopRetryIgnore("Schema migration", (Throwable)e, true);
                            switch (userResponse) {
                                case CANCEL: 
                                case STOP: {
                                    throw e;
                                }
                            }
                        }
                        monitor.worked(1);
                        ++n2;
                    }
                    if (txnManager != null && txnManager.isSupportsTransactions()) {
                        txnManager.commit(session);
                    }
                }
                finally {
                    if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
                        try {
                            txnManager.setAutoCommit(session.getProgressMonitor(), true);
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                    }
                }
                monitor.done();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CMPException("Schema migration error", (Throwable)e);
        }
    }
}

