/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.commands;

import java.awt.Desktop;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class OpenLinkInWindowHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String TITLE = "Search selection in web";
    private static final String SEARCH_WEB_ADDRESS_PREFIX = "https://www.google.com/search?q=";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SQLEditor editor = (SQLEditor)((Object)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditor.class));
        if (editor == null) {
            DBWorkbench.getPlatformUI().showError(TITLE, "No suitable editor was found for SQL");
            return null;
        }
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (this.isSelectedTextNullOrEmpty(selection)) {
            DBWorkbench.getPlatformUI().showError(TITLE, "No text was selected");
            return null;
        }
        TextSelection textSelection = (TextSelection)selection;
        String googleLink = SEARCH_WEB_ADDRESS_PREFIX + textSelection.getText().replaceAll(" ", "%20").trim();
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            UIUtils.launchProgram((String)googleLink);
        } else {
            DBWorkbench.getPlatformUI().showError(TITLE, "Desktop is not supported.");
        }
        return null;
    }

    private boolean isSelectedTextNullOrEmpty(ISelection selection) {
        if (selection == null) {
            return true;
        }
        if (selection.isEmpty() || !(selection instanceof TextSelection)) {
            return true;
        }
        TextSelection textSelection = (TextSelection)selection;
        String selectedText = textSelection.getText();
        return selectedText == "" || selectedText.isEmpty();
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setText(SQLEditorMessages.editors_sql_actions_search_selected_text_online);
        element.setTooltip(SQLEditorMessages.editors_sql_actions_search_selected_text_online_tip);
    }
}

