/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.BufferedBlob;
import com.ingres.gcf.util.ByteBuffer;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlVarByte;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;

public class SqlLongByteCache
extends SqlData {
    private ByteBuffer buffer = null;
    private int segSize = 8192;

    public SqlLongByteCache() {
        super(true);
    }

    public SqlLongByteCache(int n) {
        super(true);
        this.segSize = n;
    }

    @Override
    public void setNull() {
        super.setNull();
        this.buffer = null;
    }

    @Override
    public String toString() {
        return "SqlCache: " + (this.buffer == null ? "NULL" : this.buffer.toString());
    }

    public void set(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new ByteBuffer(this.segSize, inputStream);
        }
    }

    public void set(SqlByte sqlByte) throws SQLException {
        if (sqlByte == null || sqlByte.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            sqlByte.extend();
            this.buffer = new ByteBuffer(this.segSize, sqlByte.value, 0, sqlByte.length);
        }
    }

    public void set(SqlVarByte sqlVarByte) throws SQLException {
        if (sqlVarByte == null || sqlVarByte.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new ByteBuffer(this.segSize, sqlVarByte.value, 0, sqlVarByte.length);
        }
    }

    public InputStream get() throws SQLException {
        return this.buffer.getIS();
    }

    public void get(OutputStream outputStream) throws SQLException {
        this.buffer.read(outputStream);
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            this.setBytes(string.getBytes());
        }
    }

    @Override
    public void setBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new ByteBuffer(this.segSize, byArray, 0, byArray.length);
        }
    }

    @Override
    public void setBinaryStream(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.buffer = new ByteBuffer(this.segSize, inputStream);
        }
    }

    @Override
    public String getString() throws SQLException {
        byte[] byArray = this.getBytes();
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    @Override
    public String getString(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return this.getBytes(Integer.MAX_VALUE);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        n = (int)Math.min((long)n, this.buffer.length());
        byte[] byArray = new byte[n];
        this.buffer.read(0L, byArray, 0, n);
        return byArray;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.buffer.getIS();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return SqlStream.getAsciiIS(SqlLongByte.byteIS2hexRdr(this.buffer.getIS()));
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        return SqlStream.getUnicodeIS(SqlLongByte.byteIS2hexRdr(this.buffer.getIS()));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return SqlLongByte.byteIS2hexRdr(this.buffer.getIS());
    }

    @Override
    public Blob getBlob() throws SQLException {
        return new BufferedBlob(this.buffer);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getBytes();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.getBytes(n);
    }
}

