/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.util.Hashtable;

public enum SqlExType {
    UNKNOWN_EXCEPTION("99"),
    CLIENTINFO_EXCEPTION("98"),
    UNSUPPORTED_FEATURE("0A"),
    DATA_ERROR("22"),
    INTEGRITY_CONSTRAINT_VOILATION("23"),
    INTEGRITY_AUTH_CREDENTIAL("28"),
    CONN_EXCEPTION("08"),
    SYNTAX_ERROR("42"),
    TRANSACTION_ROLLBACK("40");

    private final String sqlstate_class;

    private SqlExType(String string2) {
        this.sqlstate_class = string2;
    }

    public String sqlStateClass() {
        return this.sqlstate_class;
    }

    public static SQLException getSqlEx(SqlExType sqlExType, String string, String string2, int n) {
        if (sqlExType == null) {
            sqlExType = SqlExType.getType(string2);
        }
        switch (sqlExType) {
            case UNSUPPORTED_FEATURE: {
                return new SQLFeatureNotSupportedException(string, string2, n);
            }
            case CLIENTINFO_EXCEPTION: {
                return new SQLClientInfoException(string, string2, n, new Hashtable<String, ClientInfoStatus>());
            }
            case CONN_EXCEPTION: {
                return new SQLNonTransientConnectionException(string, string2, n);
            }
            case DATA_ERROR: {
                return new SQLDataException(string, string2, n);
            }
            case INTEGRITY_CONSTRAINT_VOILATION: {
                return new SQLIntegrityConstraintViolationException(string, string2, n);
            }
            case SYNTAX_ERROR: {
                return new SQLSyntaxErrorException(string, string2, n);
            }
            case INTEGRITY_AUTH_CREDENTIAL: {
                return new SQLInvalidAuthorizationSpecException(string, string2, n);
            }
            case TRANSACTION_ROLLBACK: {
                return new SQLTransactionRollbackException(string, string2, n);
            }
        }
        return new SQLException(string, string2, n);
    }

    public static SqlExType getType(String string) {
        SqlExType sqlExType = UNKNOWN_EXCEPTION;
        String string2 = null;
        if (string == null) {
            string2 = UNKNOWN_EXCEPTION.sqlStateClass();
        } else {
            try {
                string2 = string.substring(0, 2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                string2 = UNKNOWN_EXCEPTION.sqlStateClass();
            }
        }
        for (SqlExType sqlExType2 : SqlExType.values()) {
            if (!string2.equals(sqlExType2.sqlStateClass())) continue;
            sqlExType = sqlExType2;
        }
        return sqlExType;
    }
}

