/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcCPVirt;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class JdbcXAVirt
extends JdbcCPVirt
implements Connection,
GcfErr {
    private boolean activeDTX = false;

    JdbcXAVirt(Connection connection, PooledConnection pooledConnection, ConnectionEventListener connectionEventListener, DrvTrace drvTrace, boolean bl) {
        super(connection, pooledConnection, connectionEventListener, drvTrace);
        this.activeDTX = bl;
        this.title = drvTrace.getTraceName() + "-XAVConnection[" + this.inst_id + "]";
        this.tr_id = "XAVirt[" + this.inst_id + "]";
        if (drvTrace.enabled(2)) {
            drvTrace.write(this.tr_id + "( " + connection + ", " + bl + " )");
        }
    }

    boolean setActiveDTX(boolean bl) {
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".setActiveDTX( " + bl + " )");
        }
        boolean bl2 = this.activeDTX;
        this.activeDTX = bl;
        return bl2;
    }

    Connection setConnection(Connection connection) {
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".setConnection( " + connection + " )");
        }
        Connection connection2 = this.conn;
        this.conn = connection;
        return connection2;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.activeDTX && bl) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".setAutoCommit(): not permitted during distributed transaction");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        super.setAutoCommit(bl);
    }

    @Override
    public void commit() throws SQLException {
        if (this.activeDTX) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".commit(): commit must be done by transaction manager!");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        super.commit();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.activeDTX) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rollback(): rollback must be done by transaction manager!");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        super.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.activeDTX) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rollback(" + savepoint + "): rollback must be done by transaction manager!");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        super.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.activeDTX) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".setSavepoint(): savepoints not allowed in distributed xact!");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        return super.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.activeDTX) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".setSavepoint('" + string + "'): savepoints not allowed in distributed xact!");
            }
            throw SqlExFactory.get(ERR_GC401F_XACT_STATE);
        }
        return super.setSavepoint(string);
    }
}

