/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.copy;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import liquibase.database.PreparedStatementFactory;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.statement.ExecutablePreparedStatement;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CopyStatement
implements ExecutablePreparedStatement {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private InputStream inputStream;

    protected CopyStatement() {
    }

    public CopyStatement(InputStream stream, String schema, String table) {
        this.inputStream = stream;
        this.schemaName = schema;
        this.tableName = table;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalog) {
        this.catalogName = catalog;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schema) {
        this.schemaName = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public boolean skipOnUnsupported() {
        return false;
    }

    public void execute(PreparedStatementFactory factory) throws DatabaseException {
        try {
            Connection connection = factory.create("select 1").getConnection();
            if (!(connection instanceof BaseConnection)) {
                throw new DatabaseException("Only postgresql support for Copy");
            }
            BaseConnection con = (BaseConnection)connection;
            String escapedTable = new PostgresDatabase().escapeTableName(this.catalogName, this.schemaName, this.tableName);
            String sql = "COPY " + escapedTable + " FROM STDIN";
            CopyManager manager = new CopyManager(con);
            manager.copyIn(sql, this.inputStream);
        }
        catch (IOException e) {
            throw new DatabaseException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new DatabaseException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean continueOnError() {
        return false;
    }
}

