/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.generator;

import com.dbeaver.ee.mockdata.engine.MockDataUtils;
import com.dbeaver.ee.mockdata.engine.model.MockValueGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractMockValueGenerator
implements MockValueGenerator {
    public static final int UNIQUE_VALUES_SET_SIZE = 1000000;
    public static final int UNIQUE_VALUE_GEN_ATTEMPTS = 100;
    protected DBSEntity dbsEntity;
    protected DBSAttributeBase attribute;
    protected Random random = new Random();
    protected int nullsPersent = 10;
    private boolean isFirstRun = true;
    private boolean isUnique;
    private Set<Object> uniqueValues;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<String, Object> properties) throws DBException {
        this.dbsEntity = (DBSEntity)container;
        this.attribute = attribute;
        if (attribute.isRequired()) {
            this.nullsPersent = 0;
        } else if (properties.get("nulls") != null) {
            this.nullsPersent = (Integer)properties.get("nulls");
        }
        if (this.nullsPersent > 100) {
            this.nullsPersent = 100;
        } else if (this.nullsPersent < 0) {
            this.nullsPersent = 0;
        }
    }

    @Override
    public void nextRow() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object generateValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isFirstRun) {
            this.isFirstRun = false;
            boolean bl = this.isUnique = MockDataUtils.checkUnique(monitor, this.dbsEntity, this.attribute) == MockDataUtils.UNIQ_TYPE.SINGLE;
            if (this.isUnique && this.attribute instanceof DBSAttributeEnumerable) {
                this.uniqueValues = new HashSet<Object>();
                Collection<DBDLabelValuePair> valuePairs = this.readColumnValues(monitor, (DBSAttributeEnumerable)this.attribute, 1000000);
                for (DBDLabelValuePair pair : valuePairs) {
                    this.uniqueValues.add(pair.getValue());
                }
            }
        }
        if (this.isUnique && this.uniqueValues != null) {
            int attempts = 0;
            Object value = null;
            while (value == null || this.uniqueValues.contains(value)) {
                if (attempts > 100) {
                    throw new DBException("\n      Can't generate appropriate unique value for the '" + this.attribute.getName() + "' <" + this.attribute.getFullTypeName() + "> attribute.\n" + "      Try to change the generator or its parameters.\n");
                }
                if (monitor.isCanceled()) {
                    return null;
                }
                value = this.generateOneValue(monitor);
                ++attempts;
            }
            this.uniqueValues.add(value);
            return value;
        }
        return this.generateOneValue(monitor);
    }

    protected abstract Object generateOneValue(DBRProgressMonitor var1) throws DBException, IOException;

    protected boolean isGenerateNULL() {
        return this.nullsPersent > 0 && (this.nullsPersent == 100 || this.random.nextInt(100) <= this.nullsPersent);
    }

    protected Collection<DBDLabelValuePair> readColumnValues(DBRProgressMonitor monitor, DBSAttributeEnumerable column, int number) throws DBException {
        DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this.dbsEntity, (String)"Read value enumeration");
        return column.getValueEnumeration(session, null, number, true);
    }

    protected Boolean getBooleanProperty(Map<String, Object> properties, String propName) {
        Object prop = properties.get(propName);
        if (prop != null) {
            if (prop instanceof Boolean) {
                return (Boolean)prop;
            }
            return CommonUtils.toBoolean((Object)prop);
        }
        return null;
    }

    protected Double getDoubleProperty(Map<String, Object> properties, String propName) {
        Object prop = properties.get(propName);
        if (prop != null) {
            if (prop instanceof Double) {
                return (Double)prop;
            }
            return CommonUtils.toDouble((Object)prop);
        }
        return null;
    }

    protected Long getLongProperty(Map<String, Object> properties, String propName) {
        Object prop = properties.get(propName);
        if (prop != null) {
            if (prop instanceof Long) {
                return (Long)prop;
            }
            return CommonUtils.toLong((Object)prop);
        }
        return null;
    }
}

