/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaGenericConstraint;
import com.dbeaver.db.netezza.model.NetezzaGenericDataSource;
import com.dbeaver.db.netezza.model.NetezzaGenericDatabase;
import com.dbeaver.db.netezza.model.NetezzaGenericProcedure;
import com.dbeaver.db.netezza.model.NetezzaGenericSchema;
import com.dbeaver.db.netezza.model.NetezzaGenericSequence;
import com.dbeaver.db.netezza.model.NetezzaGenericSynonym;
import com.dbeaver.db.netezza.model.NetezzaGenericTable;
import com.dbeaver.db.netezza.model.NetezzaGenericTableColumn;
import com.dbeaver.db.netezza.model.NetezzaGenericView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelForeignKeyFetcher;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.ext.netezza.model.NetezzaMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class NetezzaMetaModelExt
extends NetezzaMetaModel
implements GenericMetaModelForeignKeyFetcher {
    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new NetezzaGenericDataSource(monitor, container, (GenericMetaModel)this);
    }

    public boolean isSystemSchema(GenericSchema schema) {
        return schema.getName().equals("DEFINITION_SCHEMA") || schema.getName().equals("INFORMATION_SCHEMA");
    }

    public boolean isSchemasOptional() {
        return false;
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog catalog) throws DBException {
        String sql = "SELECT * FROM " + DBUtils.getQuotedIdentifier((DBSObject)catalog) + ".DEFINITION_SCHEMA._V_SCHEMA ORDER BY SCHEMA";
        boolean schemaReadFailed = false;
        ArrayList<GenericSchema> result = new ArrayList<GenericSchema>();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(sql);){
                    while (dbResult.next()) {
                        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMA");
                        String owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
                        Timestamp createDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATEDATE");
                        long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SCHEMAID");
                        NetezzaGenericSchema schema = new NetezzaGenericSchema(dataSource, catalog, name, schemaId, owner, createDate);
                        result.add(schema);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (dataSource.discoverErrorType((Throwable)e) == DBPErrorAssistant.ErrorType.CONNECTION_LOST) {
                throw new DBException((Throwable)e, (DBPDataSource)dataSource);
            }
            schemaReadFailed = true;
        }
        if (schemaReadFailed) {
            return super.loadSchemas(session, dataSource, catalog);
        }
        return result;
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if ("SYNONYM".equalsIgnoreCase(tableType)) {
            return null;
        }
        if (tableType != null && this.isView(tableType)) {
            return new NetezzaGenericView(container, tableName, tableType, dbResult);
        }
        return new NetezzaGenericTable(container, tableName, tableType, dbResult);
    }

    public boolean supportsSynonyms(GenericDataSource dataSource) {
        return true;
    }

    /*
     * Loose catch block
     */
    public List<? extends GenericSynonym> loadSynonyms(DBRProgressMonitor monitor, GenericStructContainer container) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read synonyms");){
                ArrayList<NetezzaGenericSynonym> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block32: {
                    throwable2 = null;
                    Object var7_11 = null;
                    dbStat = session.prepareStatement("SELECT * FROM " + DBUtils.getQuotedIdentifier((DBSObject)container.getCatalog()) + ".DEFINITION_SCHEMA._V_SYNONYM WHERE SCHEMA = ? ORDER BY SYNONYM_NAME");
                    dbStat.setString(1, container.getName());
                    ArrayList<NetezzaGenericSynonym> result = new ArrayList<NetezzaGenericSynonym>();
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = dbResult.getString("SYNONYM_NAME");
                            String targetObjectSchema = dbResult.getString("REFSCHEMA");
                            String targetObjectName = dbResult.getString("REFOBJNAME");
                            NetezzaGenericSynonym synonym = new NetezzaGenericSynonym(container, name, targetObjectSchema, targetObjectName);
                            result.add(synonym);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block32;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    /*
     * Loose catch block
     */
    public List<GenericSequence> loadSequences(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer container) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read sequences");){
                ArrayList<GenericSequence> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block32: {
                    throwable2 = null;
                    Object var7_11 = null;
                    dbStat = session.prepareStatement("SELECT * FROM " + DBUtils.getQuotedIdentifier((DBSObject)container.getCatalog()) + ".DEFINITION_SCHEMA._V_SEQUENCE WHERE SCHEMA = ? ORDER BY SEQNAME");
                    dbStat.setString(1, container.getName());
                    ArrayList<GenericSequence> result = new ArrayList<GenericSequence>();
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = dbResult.getString("SEQNAME");
                            NetezzaGenericSequence sequence = new NetezzaGenericSequence(container, name, "");
                            result.add(sequence);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block32;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public NetezzaGenericDatabase createCatalogImpl(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        return new NetezzaGenericDatabase(dataSource, catalogName);
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException {
        DBSObject parentObject = owner.getParentObject();
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT RELATION AS TABLE_NAME, ATTNAME as COLUMN_NAME, CONSTRAINTNAME AS PK_NAME, CONTYPE FROM " + (parentObject != null ? String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)parentObject)) + ".DEFINITION_SCHEMA." : "") + "_V_RELATION_KEYDATA WHERE SCHEMA=? AND " + (forParent != null ? "RELATION=? AND " : "") + "(CONTYPE='u' OR CONTYPE='p')");
        if (forParent != null) {
            dbStat.setString(1, forParent.getSchema().getName());
            dbStat.setString(2, forParent.getName());
        } else {
            dbStat.setString(1, owner.getName());
        }
        return dbStat;
    }

    public DBSEntityConstraintType getUniqueConstraintType(JDBCResultSet dbResult) {
        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONTYPE");
        if (type != null && type.equals("u")) {
            return DBSEntityConstraintType.UNIQUE_KEY;
        }
        return DBSEntityConstraintType.PRIMARY_KEY;
    }

    public GenericUniqueKey createConstraintImpl(GenericTableBase table, String constraintName, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        return new NetezzaGenericConstraint(table, constraintName, null, constraintType, persisted);
    }

    public JDBCStatement prepareForeignKeysLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException {
        DBSObject parentObject = owner.getParentObject();
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT RELATION AS FKTABLE_NAME, CONSTRAINTNAME AS FK_NAME,\nPKDATABASE AS PKTABLE_CAT, PKSCHEMA AS PKTABLE_SCHEM, PKRELATION AS PKTABLE_NAME,\nDATABASE AS FKTABLE_CAT, SCHEMA AS FKTABLE_SCHEM, CONSEQ AS KEY_SEQ,\nUPDT_TYPE AS UPDATE_RULE, DEL_TYPE AS DELETE_RULE, DEFERRABLECONSTR AS DEFERRABILITY, REFCONSTRNAME AS PK_NAME, PKATTNAME AS PKCOLUMN_NAME, ATTNAME AS FKCOLUMN_NAME FROM " + (parentObject != null ? String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)parentObject)) + ".DEFINITION_SCHEMA." : "") + "_V_RELATION_KEYDATA WHERE CONTYPE='f'" + " AND SCHEMA=?" + (forParent != null ? " AND RELATION=?" : ""));
        if (forParent != null) {
            dbStat.setString(1, forParent.getSchema().getName());
            dbStat.setString(2, forParent.getName());
        } else {
            dbStat.setString(1, owner.getName());
        }
        return dbStat;
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public boolean isTableColumnCommentEditable() {
        return true;
    }

    public GenericProcedure createProcedureImpl(GenericStructContainer container, String procedureName, String specificName, String remarks, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        return new NetezzaGenericProcedure(container, procedureName, specificName, remarks, procedureType, functionResultType);
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, @Nullable JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new NetezzaGenericTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public DBSForeignKeyModifyRule fetchUpdateRule(GenericMetaObject foreignKeyObject, JDBCResultSet dbResult) {
        String updateRuleName = GenericUtils.safeGetStringTrimmed((GenericMetaObject)foreignKeyObject, (ResultSet)dbResult, (String)"UPDATE_RULE");
        return JDBCUtils.getCascadeFromName((String)updateRuleName);
    }

    public DBSForeignKeyModifyRule fetchDeleteRule(GenericMetaObject foreignKeyObject, JDBCResultSet dbResult) {
        String deleteRuleName = GenericUtils.safeGetStringTrimmed((GenericMetaObject)foreignKeyObject, (ResultSet)dbResult, (String)"DELETE_RULE");
        return JDBCUtils.getCascadeFromName((String)deleteRuleName);
    }

    public DBSForeignKeyDeferability fetchDeferability(GenericMetaObject foreignKeyObject, JDBCResultSet dbResult) {
        String deferabilityName;
        switch (deferabilityName = GenericUtils.safeGetStringTrimmed((GenericMetaObject)foreignKeyObject, (ResultSet)dbResult, (String)"DEFERRABILITY")) {
            case "INITIALLY DEFERRED": {
                return DBSForeignKeyDeferability.INITIALLY_DEFERRED;
            }
            case "INITIALLY IMMEDIATE": {
                return DBSForeignKeyDeferability.INITIALLY_IMMEDIATE;
            }
            case "NOT DEFERRABLE": {
                return DBSForeignKeyDeferability.NOT_DEFERRABLE;
            }
        }
        return DBSForeignKeyDeferability.UNKNOWN;
    }
}

