/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingTargetTrackingScalingPolicyConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingTargetTrackingScalingPolicyConfigurationDescription> {
    private static final SdkField<Boolean> DISABLE_SCALE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableScaleIn").getter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.getter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription::disableScaleIn)).setter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.setter(Builder::disableScaleIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableScaleIn").build()}).build();
    private static final SdkField<Integer> SCALE_IN_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScaleInCooldown").getter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.getter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription::scaleInCooldown)).setter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.setter(Builder::scaleInCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleInCooldown").build()}).build();
    private static final SdkField<Integer> SCALE_OUT_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScaleOutCooldown").getter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.getter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription::scaleOutCooldown)).setter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.setter(Builder::scaleOutCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleOutCooldown").build()}).build();
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TargetValue").getter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.getter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription::targetValue)).setter(AutoScalingTargetTrackingScalingPolicyConfigurationDescription.setter(Builder::targetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLE_SCALE_IN_FIELD, SCALE_IN_COOLDOWN_FIELD, SCALE_OUT_COOLDOWN_FIELD, TARGET_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean disableScaleIn;
    private final Integer scaleInCooldown;
    private final Integer scaleOutCooldown;
    private final Double targetValue;

    private AutoScalingTargetTrackingScalingPolicyConfigurationDescription(BuilderImpl builder) {
        this.disableScaleIn = builder.disableScaleIn;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.targetValue = builder.targetValue;
    }

    public Boolean disableScaleIn() {
        return this.disableScaleIn;
    }

    public Integer scaleInCooldown() {
        return this.scaleInCooldown;
    }

    public Integer scaleOutCooldown() {
        return this.scaleOutCooldown;
    }

    public Double targetValue() {
        return this.targetValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.disableScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingTargetTrackingScalingPolicyConfigurationDescription)) {
            return false;
        }
        AutoScalingTargetTrackingScalingPolicyConfigurationDescription other = (AutoScalingTargetTrackingScalingPolicyConfigurationDescription)obj;
        return Objects.equals(this.disableScaleIn(), other.disableScaleIn()) && Objects.equals(this.scaleInCooldown(), other.scaleInCooldown()) && Objects.equals(this.scaleOutCooldown(), other.scaleOutCooldown()) && Objects.equals(this.targetValue(), other.targetValue());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingTargetTrackingScalingPolicyConfigurationDescription").add("DisableScaleIn", (Object)this.disableScaleIn()).add("ScaleInCooldown", (Object)this.scaleInCooldown()).add("ScaleOutCooldown", (Object)this.scaleOutCooldown()).add("TargetValue", (Object)this.targetValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisableScaleIn": {
                return Optional.ofNullable(clazz.cast(this.disableScaleIn()));
            }
            case "ScaleInCooldown": {
                return Optional.ofNullable(clazz.cast(this.scaleInCooldown()));
            }
            case "ScaleOutCooldown": {
                return Optional.ofNullable(clazz.cast(this.scaleOutCooldown()));
            }
            case "TargetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingTargetTrackingScalingPolicyConfigurationDescription, T> g) {
        return obj -> g.apply((AutoScalingTargetTrackingScalingPolicyConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean disableScaleIn;
        private Integer scaleInCooldown;
        private Integer scaleOutCooldown;
        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingTargetTrackingScalingPolicyConfigurationDescription model) {
            this.disableScaleIn(model.disableScaleIn);
            this.scaleInCooldown(model.scaleInCooldown);
            this.scaleOutCooldown(model.scaleOutCooldown);
            this.targetValue(model.targetValue);
        }

        public final Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        public final Integer getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        public final Integer getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public AutoScalingTargetTrackingScalingPolicyConfigurationDescription build() {
            return new AutoScalingTargetTrackingScalingPolicyConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingTargetTrackingScalingPolicyConfigurationDescription> {
        public Builder disableScaleIn(Boolean var1);

        public Builder scaleInCooldown(Integer var1);

        public Builder scaleOutCooldown(Integer var1);

        public Builder targetValue(Double var1);
    }
}

