/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorTable;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;

public class SQLGeneratorSelect
extends SQLGeneratorTable {
    private boolean columnList = true;

    public void setColumnList(boolean columnList) {
        this.columnList = columnList;
    }

    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
        sql.append("SELECT ");
        boolean hasAttr = false;
        if (this.columnList) {
            for (DBSEntityAttribute dBSEntityAttribute : this.getAllAttributes(monitor, object)) {
                if (DBUtils.isHiddenObject((Object)dBSEntityAttribute)) continue;
                if (hasAttr) {
                    sql.append(", ");
                }
                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSEntityAttribute, (DBPEvaluationContext)DBPEvaluationContext.DML));
                hasAttr = true;
            }
            if (hasAttr) {
                sql.append(this.getLineSeparator());
            }
        }
        if (!hasAttr) {
            sql.append("* ");
        }
        sql.append("FROM ").append(this.getEntityName(object));
        sql.append(";\n");
    }
}

