/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.model;

import com.dbeaver.ee.scmp.model.CMPInput;
import com.dbeaver.ee.scmp.model.CMPUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.structure.DatabaseObject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public class CMPOptions {
    private CMPInput sourceInput;
    private CMPInput targetInput;
    private final Map<DBSObjectContainer, DBSObjectContainer> containerMapping = new HashMap<DBSObjectContainer, DBSObjectContainer>();
    private final List<DBSObjectType> objectTypes = new ArrayList<DBSObjectType>();
    private Set<Class<? extends DatabaseObject>> excludedObjectTypes = new HashSet<Class<? extends DatabaseObject>>();
    private boolean openNewConnection;
    private String diffEngineId;
    private String defaultReportEngineId;
    private boolean doCreate = true;
    private boolean doDrop = true;
    private boolean doChange = true;
    private boolean arrangeSchemas = true;

    public CMPOptions(@NotNull CMPInput sourceInput, @Nullable CMPInput targetInput) {
        this.sourceInput = sourceInput;
        this.targetInput = targetInput;
    }

    @NotNull
    public CMPInput getSourceInput() {
        return this.sourceInput;
    }

    @Nullable
    public CMPInput getTargetInput() {
        return this.targetInput;
    }

    @NotNull
    public CMPInput getChangelogInput() {
        return this.targetInput != null ? this.targetInput : this.sourceInput;
    }

    @NotNull
    public List<DBSObjectType> getObjectTypes() {
        return this.objectTypes;
    }

    public boolean isOpenNewConnection() {
        return this.openNewConnection;
    }

    public void setOpenNewConnection(boolean openNewConnection) {
        this.openNewConnection = openNewConnection;
    }

    public String getDiffEngineId() {
        return this.diffEngineId;
    }

    public void setDiffEngineId(String diffEngineId) {
        this.diffEngineId = diffEngineId;
    }

    public String getDefaultReportEngineId() {
        return this.defaultReportEngineId;
    }

    public void setDefaultReportEngineId(String defaultReportEngineId) {
        this.defaultReportEngineId = defaultReportEngineId;
    }

    public boolean isDoCreate() {
        return this.doCreate;
    }

    public void setDoCreate(boolean doCreate) {
        this.doCreate = doCreate;
    }

    public boolean isDoDrop() {
        return this.doDrop;
    }

    public void setDoDrop(boolean doDrop) {
        this.doDrop = doDrop;
    }

    public boolean isDoChange() {
        return this.doChange;
    }

    public void setDoChange(boolean doChange) {
        this.doChange = doChange;
    }

    public boolean isArrangeSchemas() {
        return this.arrangeSchemas;
    }

    public void setArrangeSchemas(boolean arrangeSchemas) {
        this.arrangeSchemas = arrangeSchemas;
    }

    public Set<Class<? extends DatabaseObject>> getExcludedObjectTypes() {
        return this.excludedObjectTypes;
    }

    public void setExcludedObjectTypes(Set<Class<? extends DatabaseObject>> excludedObjectTypes) {
        this.excludedObjectTypes = excludedObjectTypes;
    }

    public void refreshSchemaMappings(boolean force) {
        if (force) {
            this.containerMapping.clear();
        }
        List<DBSObjectContainer> sourceContainers = this.getSourceContainers();
        List<DBSObjectContainer> targetContainers = this.getTargetContainers();
        int i = 0;
        while (i < sourceContainers.size()) {
            if (i >= targetContainers.size()) break;
            DBSObjectContainer targetContainer = this.containerMapping.get(sourceContainers.get(i));
            if (targetContainer == null || !targetContainers.contains(targetContainer)) {
                this.containerMapping.put(sourceContainers.get(i), targetContainers.get(i));
            }
            ++i;
        }
    }

    @NotNull
    public List<DBSObjectContainer> getTargetContainers() {
        return CMPUtils.getContainers(this.targetInput.getInputObjects(), DBSObjectContainer.class, false);
    }

    @NotNull
    public List<DBSObjectContainer> getSourceContainers() {
        return CMPUtils.getContainers(this.sourceInput.getInputObjects(), DBSObjectContainer.class, false);
    }

    public void mapContainers(@NotNull DBSObjectContainer source, @Nullable DBSObjectContainer target) {
        if (target == null) {
            this.containerMapping.remove(source);
        } else {
            this.containerMapping.put(source, target);
        }
    }

    @Nullable
    public DBSObjectContainer getTargetContainer(@NotNull DBSObjectContainer sourceContainer) {
        return this.containerMapping.get(sourceContainer);
    }

    @Nullable
    public DBSObjectContainer getSourceContainer(@NotNull DBSObjectContainer targetContainer) {
        for (Map.Entry<DBSObjectContainer, DBSObjectContainer> entry : this.containerMapping.entrySet()) {
            if (entry.getValue() != targetContainer) continue;
            return entry.getKey();
        }
        return null;
    }

    public DBSObjectContainer getSourceContainer(String containerName) {
        for (Map.Entry<DBSObjectContainer, DBSObjectContainer> entry : this.containerMapping.entrySet()) {
            if (!containerName.equalsIgnoreCase(entry.getValue().getName())) continue;
            return entry.getKey();
        }
        return null;
    }
}

