/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import java.util.logging.Level;
import liquibase.diff.compare.CompareControl;
import liquibase.logging.LogMessageFilter;
import liquibase.logging.Logger;
import liquibase.logging.core.AbstractLogger;
import liquibase.logging.core.DefaultLogMessageFilter;
import org.jkiss.dbeaver.Log;

public class LBUtils {
    private static final Log log = Log.getLog(LBUtils.class);
    private static final Logger LOGGER_STUB = new LBLoggerImpl((LogMessageFilter)new DefaultLogMessageFilter());

    public static String getTargetSchema(CompareControl control, String sourceSchema) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null) {
                if (sc.getReferenceSchema().getSchemaName() != null && sc.getReferenceSchema().getSchemaName().equalsIgnoreCase(sourceSchema)) {
                    return sc.getComparisonSchema().getSchemaName();
                }
                if (sc.getReferenceSchema().getCatalogName() != null && sc.getReferenceSchema().getCatalogName().equalsIgnoreCase(sourceSchema)) {
                    return sc.getComparisonSchema().getCatalogName();
                }
            }
            ++n2;
        }
        return null;
    }

    public static String getSourceSchema(CompareControl control, String targetSchema) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null) {
                if (sc.getComparisonSchema().getSchemaName() != null && sc.getComparisonSchema().getSchemaName().equalsIgnoreCase(targetSchema)) {
                    return sc.getReferenceSchema().getSchemaName();
                }
                if (sc.getComparisonSchema().getCatalogName() != null && sc.getComparisonSchema().getCatalogName().equalsIgnoreCase(targetSchema)) {
                    return sc.getReferenceSchema().getCatalogName();
                }
            }
            ++n2;
        }
        return null;
    }

    public static String getSourceCatalog(CompareControl control, String targetCatalog) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null && sc.getComparisonSchema().getCatalogName() != null && sc.getComparisonSchema().getCatalogName().equalsIgnoreCase(targetCatalog)) {
                return sc.getReferenceSchema().getCatalogName();
            }
            ++n2;
        }
        return null;
    }

    private static class LBLoggerImpl
    extends AbstractLogger {
        LBLoggerImpl(LogMessageFilter filter) {
            super(filter);
        }

        public void severe(String message) {
            log.error((Object)message);
        }

        public void severe(String message, Throwable e) {
            log.error((Object)message, e);
        }

        public void warning(String message) {
            log.warn((Object)message);
        }

        public void warning(String message, Throwable e) {
            log.warn((Object)message, e);
        }

        public void info(String message) {
        }

        public void info(String message, Throwable e) {
        }

        public void debug(String message) {
        }

        public void debug(String message, Throwable e) {
        }

        public void log(Level level, String message, Throwable e) {
            LOGGER_STUB.log(level, message, e);
        }
    }
}

