/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.dbeaver.ee.scmp.impl.liquibase.LBObjectChangeFilter;
import com.dbeaver.ee.scmp.impl.liquibase.LBResultChangeSet;
import com.dbeaver.ee.scmp.impl.liquibase.LBSnapshotListener;
import com.dbeaver.ee.scmp.impl.liquibase.LBUtils;
import com.dbeaver.ee.scmp.model.CMPCompareEngine;
import com.dbeaver.ee.scmp.model.CMPException;
import com.dbeaver.ee.scmp.model.CMPInput;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddDefaultValueChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.EmptyDatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.snapshot.SnapshotListener;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.DatabaseObjectFactory;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.StringUtil;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class LBCompareEngine
implements CMPCompareEngine {
    private static final Log log = Log.getLog(LBCompareEngine.class);
    private static final String NEW_SCHEMA_PREFIX = "new_";
    private DBCExecutionContext sourceContext;
    private DBCExecutionContext targetContext;

    @Override
    public CMPResult compareObjects(DBRProgressMonitor monitor, CMPOptions options) throws CMPException {
        CompareControl.SchemaComparison[] finalSchemaComparisons;
        Set<Object> targetSchemas;
        CMPInput sourceInput = options.getSourceInput();
        CMPInput targetInput = options.getTargetInput();
        long startTime = System.currentTimeMillis();
        Set<Object> targetCatalogs = targetInput == null ? new HashSet() : LBCompareEngine.computeContainerList(targetInput, DBSCatalog.class, true);
        Set<String> sourceSchemas = LBCompareEngine.computeContainerList(sourceInput, DBSSchema.class, false);
        if (sourceSchemas.isEmpty()) {
            sourceSchemas = LBCompareEngine.computeContainerList(sourceInput, DBSCatalog.class, false);
        }
        Set<Object> set = targetSchemas = targetInput == null ? new HashSet() : LBCompareEngine.computeContainerList(targetInput, DBSSchema.class, false);
        if (targetInput != null && targetSchemas.isEmpty()) {
            targetSchemas = LBCompareEngine.computeContainerList(targetInput, DBSCatalog.class, false);
        }
        monitor.beginTask("Compare source and target objects", 6);
        monitor.subTask("Create databases meta");
        Database sourceDatabase = this.getDatabase(monitor, sourceInput, true);
        Database targetDatabase = targetInput == null ? null : this.getDatabase(monitor, targetInput, false);
        List<String> addSchemas = this.arrangeInputs(new ArrayList<String>(sourceSchemas), new ArrayList<Object>(targetSchemas), options.isArrangeSchemas());
        targetSchemas.addAll(addSchemas);
        CompareControl.ComputedSchemas computedSchemas = targetSchemas.isEmpty() ? null : CompareControl.computeSchemas((String)(targetSchemas.isEmpty() ? null : String.join((CharSequence)",", targetSchemas)), (String)(sourceSchemas.isEmpty() ? null : String.join((CharSequence)",", sourceSchemas)), (String)(targetSchemas.isEmpty() ? null : String.join((CharSequence)",", targetSchemas)), null, null, null, null, (Database)sourceDatabase);
        monitor.worked(1);
        CompareControl.SchemaComparison[] schemaComparisonArray = finalSchemaComparisons = computedSchemas == null ? null : computedSchemas.finalSchemaComparisons;
        if (finalSchemaComparisons != null && !targetCatalogs.isEmpty() && targetDatabase != null) {
            this.schemaCorrect(finalSchemaComparisons, String.join((CharSequence)",", targetCatalogs), targetDatabase);
        }
        String compareTypes = null;
        Class<? extends DatabaseObject>[] snapshotType = this.parseSnapshotTypes(new String[0]);
        CompareControl control = new CompareControl(finalSchemaComparisons, compareTypes);
        monitor.subTask("Create source database snapshot");
        DatabaseSnapshot sourceSnapshot = this.createDatabaseSnapshot(sourceDatabase, sourceInput, new LBSnapshotListener("SRC", monitor), snapshotType, null);
        sourceSnapshot.setSchemaComparisons(control.getSchemaComparisons());
        monitor.worked(1);
        if (sourceDatabase instanceof OracleDatabase && targetDatabase instanceof PostgresDatabase) {
            this.fixOracleNumberType(sourceSnapshot);
        }
        monitor.subTask("Create target database snapshot");
        DatabaseSnapshot targetSnapshot = targetInput == null ? this.createDatabaseSnapshot(sourceDatabase, null, new LBSnapshotListener("NEW", monitor), snapshotType, null) : this.createDatabaseSnapshot(targetDatabase, targetInput, new LBSnapshotListener("TARGET", monitor), snapshotType, null);
        targetSnapshot.setSchemaComparisons(control.getSchemaComparisons());
        monitor.worked(1);
        List<ChangeSet> changesets = this.performDiff(monitor, control, targetSnapshot, sourceSnapshot, options);
        CMPResult result = new CMPResult(new LBResultChangeSet(options, sourceDatabase, targetDatabase, control, changesets));
        result.setCompareTime(System.currentTimeMillis() - startTime);
        result.setSuccess(true);
        return result;
    }

    private void fixOracleNumberType(DatabaseSnapshot sourceSnapshot) {
        Set tables = sourceSnapshot.get(Table.class);
        if (!CommonUtils.isEmpty((Collection)tables)) {
            for (DatabaseObject table : tables) {
                List columnList = ((Table)table).getColumns();
                if (CommonUtils.isEmpty((Collection)columnList)) continue;
                for (Column column : columnList) {
                    DataType dataType = column.getType();
                    if (!dataType.getTypeName().equals("NUMBER") || !dataType.toString().contains("*")) continue;
                    dataType.setColumnSize(Integer.valueOf(38));
                }
            }
        }
    }

    private void schemaCorrect(CompareControl.SchemaComparison[] comps, String targetCatalogs, Database targetDatabase) {
        if (targetCatalogs == null && targetDatabase.supportsCatalogs()) {
            targetCatalogs = targetDatabase.getDefaultCatalogName();
            CompareControl.SchemaComparison[] schemaComparisonArray = comps;
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                CompareControl.SchemaComparison comp = schemaComparisonArray[n2];
                CatalogAndSchema ref = comp.getReferenceSchema();
                if (!ref.getCatalogName().equals(targetCatalogs)) {
                    try {
                        Field f = ref.getClass().getDeclaredField("catalogName");
                        f.setAccessible(true);
                        f.set(ref, targetCatalogs);
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to set catalog for " + comp.toString()), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    private List<ChangeSet> performDiff(DBRProgressMonitor monitor, CompareControl control, DatabaseSnapshot targetSnapshot, DatabaseSnapshot sourceSnapshot, CMPOptions options) throws CMPException {
        try {
            monitor.subTask("Compare snapshots");
            DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(sourceSnapshot, targetSnapshot, control);
            monitor.worked(1);
            if (targetSnapshot.getDatabase() instanceof OracleDatabase) {
                this.fixLiquibaseOracleViews(diffResult.getMissingObjects(View.class), control);
            }
            monitor.subTask("Prepare diff processor");
            boolean includeCatalog = false;
            boolean includeSchema = true;
            boolean includeTablespace = true;
            DiffOutputControl diffOutputControl = new DiffOutputControl(includeCatalog, includeSchema, includeTablespace, control.getSchemaComparisons());
            LBObjectChangeFilter objectChangeFilter = new LBObjectChangeFilter(options, sourceSnapshot.getDatabase());
            diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)objectChangeFilter);
            CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
            int n = schemaComparisonArray.length;
            int n2 = 0;
            while (n2 < n) {
                CompareControl.SchemaComparison schema = schemaComparisonArray[n2];
                diffOutputControl.addIncludedSchema(schema.getReferenceSchema());
                diffOutputControl.addIncludedSchema(schema.getComparisonSchema());
                ++n2;
            }
            monitor.worked(1);
            monitor.subTask("Generate changesets");
            DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffResult, diffOutputControl);
            diffToChangeLog.setChangeSetAuthor("dbeaver");
            List changeSets = diffToChangeLog.generateChangeSets();
            this.fixLiquibaseChanges(changeSets, control, sourceSnapshot.getDatabase(), targetSnapshot.getDatabase());
            monitor.worked(1);
            return changeSets;
        }
        catch (Exception e) {
            throw new CMPException("Error generating diff", e);
        }
    }

    private boolean isSourceSchema(CompareControl control, String shemaName) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null) {
                if (sc.getReferenceSchema().getSchemaName() != null && sc.getReferenceSchema().getSchemaName().equalsIgnoreCase(shemaName)) {
                    return true;
                }
                if (sc.getReferenceSchema().getCatalogName() != null && sc.getReferenceSchema().getCatalogName().equalsIgnoreCase(shemaName)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private void fixLiquibaseOracleViews(Set<View> views, CompareControl control) {
        views.parallelStream().forEach(view -> {
            String currSchema;
            Schema schema = view.getSchema();
            if (schema != null && (currSchema = schema.getName()) != null && this.isSourceSchema(control, currSchema)) {
                view.setSchema(schema.getCatalogName() != null ? LBUtils.getTargetSchema(control, schema.getCatalogName()) : null, LBUtils.getTargetSchema(control, currSchema));
            }
        });
    }

    private void fixLiquibaseChanges(List<ChangeSet> changeSets, CompareControl control, Database sourceDatabase, Database targetDatabase) {
        for (ChangeSet cs : changeSets) {
            for (Change change : cs.getChanges()) {
                DatabaseFunction defaultValueComputed;
                AddDefaultValueChange valueChange;
                String currSchema;
                if (change instanceof CreateTableChange) {
                    currSchema = ((CreateTableChange)change).getSchemaName();
                    if (currSchema != null && this.isSourceSchema(control, currSchema)) {
                        ((CreateTableChange)change).setSchemaName(LBUtils.getTargetSchema(control, currSchema));
                    }
                    if (!(sourceDatabase instanceof PostgresDatabase)) continue;
                    for (ColumnConfig columnConfig : ((ChangeWithColumns)change).getColumns()) {
                        DatabaseFunction defaultValueComputed2;
                        if (columnConfig.getType().startsWith("INTERVAL")) {
                            columnConfig.setType(SQLUtils.stripColumnTypeModifiers((String)columnConfig.getType()));
                            continue;
                        }
                        if (!columnConfig.getType().equals("INET") || (defaultValueComputed2 = this.quoteDatabaseFunction(columnConfig.getDefaultValueComputed())) == null) continue;
                        columnConfig.setDefaultValueComputed(defaultValueComputed2);
                    }
                    continue;
                }
                if (change instanceof CreateViewChange) {
                    currSchema = ((CreateViewChange)change).getSchemaName();
                    if (currSchema == null || !this.isSourceSchema(control, currSchema)) continue;
                    ((CreateViewChange)change).setSchemaName(LBUtils.getTargetSchema(control, currSchema));
                    continue;
                }
                if (change instanceof CreateIndexChange) {
                    currSchema = ((CreateIndexChange)change).getSchemaName();
                    if (currSchema == null || !this.isSourceSchema(control, currSchema)) continue;
                    ((CreateIndexChange)change).setSchemaName(LBUtils.getTargetSchema(control, currSchema));
                    continue;
                }
                if (change instanceof ChangeWithColumns) {
                    ColumnConfig columnConfig;
                    columnConfig = ((ChangeWithColumns)change).getColumns().iterator();
                    while (columnConfig.hasNext()) {
                        ColumnConfig cc = (ColumnConfig)columnConfig.next();
                        this.fixColumnDefinition(sourceDatabase, targetDatabase, cc);
                    }
                    continue;
                }
                if (!(change instanceof AddDefaultValueChange) || !(sourceDatabase instanceof PostgresDatabase) || !(valueChange = (AddDefaultValueChange)change).getColumnDataType().equals("inet") || (defaultValueComputed = this.quoteDatabaseFunction(valueChange.getDefaultValueComputed())) == null) continue;
                valueChange.setDefaultValueComputed(defaultValueComputed);
            }
        }
    }

    private DatabaseFunction quoteDatabaseFunction(DatabaseFunction defaultValueComputed) {
        String computedValue;
        if (defaultValueComputed != null && !CommonUtils.isEmpty((String)(computedValue = defaultValueComputed.getValue())) && !computedValue.startsWith("'") && Character.isDigit(computedValue.charAt(0))) {
            String quotedDefaultInetValue = "'" + computedValue + "'";
            return new DatabaseFunction(quotedDefaultInetValue);
        }
        return defaultValueComputed;
    }

    private void fixColumnDefinition(Database sourceDatabase, Database targetDatabase, ColumnConfig columnConfig) {
        String type;
        if (targetDatabase instanceof MySQLDatabase && (type = columnConfig.getType()) != null && type.startsWith("GEOMETRY")) {
            columnConfig.setType(SQLUtils.stripColumnTypeModifiers((String)type));
        }
    }

    private List<String> arrangeInputs(List<String> sourceSchemas, List<String> targetSchemas, boolean addNewSchemas) throws CMPException {
        ArrayList<String> addedSchemas = new ArrayList<String>();
        if (sourceSchemas.size() == targetSchemas.size()) {
            return Collections.emptyList();
        }
        if (sourceSchemas.size() < targetSchemas.size()) {
            throw new CMPException(String.format("The number of source schemas (%d) cannot be less than the number of target schemas (%d)", sourceSchemas.size(), targetSchemas.size()));
        }
        if (!addNewSchemas) {
            throw new CMPException(String.format("The number of source schemas (%d) cannot be more than the number of target schemas (%d)", sourceSchemas.size(), targetSchemas.size()));
        }
        int index = targetSchemas.size();
        while (index < sourceSchemas.size()) {
            String newSchema = NEW_SCHEMA_PREFIX + sourceSchemas.get(index);
            addedSchemas.add(newSchema);
            ++index;
        }
        return addedSchemas;
    }

    public static Set<String> computeContainerList(CMPInput input, Class<? extends DBSObject> containerType, boolean singleName) {
        LinkedHashSet<String> schemaNames = new LinkedHashSet<String>();
        for (DBSObject object : input.getInputObjects()) {
            DBSObject container = null;
            DBSObject po = object;
            while (po != null) {
                if (containerType.isInstance(po)) {
                    container = po;
                    break;
                }
                po = po.getParentObject();
            }
            if (container == null) continue;
            schemaNames.add(container.getName());
            if (singleName) break;
        }
        return schemaNames;
    }

    public Class<? extends DatabaseObject>[] parseSnapshotTypes(String ... snapshotTypes) {
        if (snapshotTypes == null || snapshotTypes.length == 0 || snapshotTypes[0] == null) {
            return null;
        }
        Set types = DatabaseObjectFactory.getInstance().parseTypes(StringUtil.join((String[])snapshotTypes, (String)","));
        return types.toArray(new Class[0]);
    }

    protected DatabaseSnapshot createDatabaseSnapshot(Database database, CMPInput input, SnapshotListener snapshotListener, Class<? extends DatabaseObject>[] snapshotTypes, ObjectChangeFilter objectChangeFilter) throws CMPException {
        ArrayList<CatalogAndSchema> catalogAndSchemas = new ArrayList<CatalogAndSchema>();
        if (input != null) {
            boolean schemalessDatabase = input.getInputObjects().size() == 1 && input.getInputObjects().get(0) instanceof DBPDataSourceContainer;
            for (DBSObject object : input.getInputObjects()) {
                List<DBSObjectContainer> containers = LBCompareEngine.getObjectContainers(object, schemalessDatabase);
                List<DBSObjectContainer> objectContainers = CMPUtils.getContainers(input.getInputObjects(), DBSObjectContainer.class, false);
                if (objectContainers.size() == 1 && objectContainers.get(0) instanceof DBPDataSource) {
                    catalogAndSchemas.add(new CatalogAndSchema(null, null));
                    continue;
                }
                if (database.supportsSchemas() && database.supportsCatalogs()) {
                    if (containers.size() == 1) {
                        catalogAndSchemas.add(new CatalogAndSchema(containers.get(0).getName(), null));
                        continue;
                    }
                    if (containers.size() <= 1) continue;
                    catalogAndSchemas.add(new CatalogAndSchema(containers.get(0).getName(), containers.get(1).getName()));
                    continue;
                }
                if (database.supportsSchemas()) {
                    if (containers.isEmpty()) continue;
                    catalogAndSchemas.add(new CatalogAndSchema(null, containers.get(0).getName()));
                    continue;
                }
                if (database.supportsCatalogs()) {
                    if (containers.isEmpty()) continue;
                    DBSObjectContainer container = containers.get(0);
                    if (container instanceof DBPDataSource) {
                        catalogAndSchemas.add(new CatalogAndSchema(null, null));
                        continue;
                    }
                    catalogAndSchemas.add(new CatalogAndSchema(container.getName(), null));
                    continue;
                }
                catalogAndSchemas.add(new CatalogAndSchema(null, null));
            }
        }
        try {
            SnapshotControl snapshotControl = new SnapshotControl(database, objectChangeFilter, (Class[])snapshotTypes);
            if (input == null) {
                return new EmptyDatabaseSnapshot(database, snapshotControl);
            }
            if (snapshotListener != null) {
                snapshotControl.setSnapshotListener(snapshotListener);
            }
            database.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            return SnapshotGeneratorFactory.getInstance().createSnapshot(catalogAndSchemas.toArray(new CatalogAndSchema[0]), database, snapshotControl);
        }
        catch (Exception e) {
            throw new CMPException("Error creating reference snapshot", e);
        }
    }

    private static List<DBSObjectContainer> getObjectContainers(DBSObject object, boolean noSchemaOrCatalog) {
        ArrayList<DBSObjectContainer> containers = new ArrayList<DBSObjectContainer>();
        DBSObject o = object;
        while (o != null) {
            DBSObject publicObject;
            DBSObject dBSObject = publicObject = noSchemaOrCatalog ? DBUtils.getPublicObject((DBSObject)o) : o;
            if (publicObject instanceof DBSObjectContainer && (noSchemaOrCatalog || !(publicObject instanceof DBPDataSource))) {
                containers.add(0, (DBSObjectContainer)publicObject);
                if (noSchemaOrCatalog) break;
            }
            o = o.getParentObject();
        }
        return containers;
    }

    protected DatabaseSnapshot createTargetSnapshot(Database targetDatabase, CompareControl compareControl, SnapshotListener snapshotListener, Class<? extends DatabaseObject>[] snapshotTypes) throws CMPException {
        DatabaseSnapshot databaseSnapshot;
        CatalogAndSchema[] schemas;
        if (compareControl == null || compareControl.getSchemaComparisons() == null) {
            schemas = new CatalogAndSchema[]{targetDatabase.getDefaultSchema()};
        } else {
            schemas = new CatalogAndSchema[compareControl.getSchemaComparisons().length];
            int i = 0;
            databaseSnapshot = compareControl.getSchemaComparisons();
            int n = ((CompareControl.SchemaComparison[])databaseSnapshot).length;
            int n2 = 0;
            while (n2 < n) {
                CompareControl.SchemaComparison comparison = databaseSnapshot[n2];
                CatalogAndSchema schema = targetDatabase.supportsSchemas() ? new CatalogAndSchema(targetDatabase.getDefaultCatalogName(), comparison.getComparisonSchema().getSchemaName()) : new CatalogAndSchema(comparison.getComparisonSchema().getSchemaName(), comparison.getComparisonSchema().getSchemaName());
                schemas[i++] = schema;
                ++n2;
            }
        }
        SnapshotControl snapshotControl = new SnapshotControl(targetDatabase, (Class[])snapshotTypes);
        if (snapshotListener != null) {
            snapshotControl.setSnapshotListener(snapshotListener);
        }
        ObjectQuotingStrategy originalStrategy = targetDatabase.getObjectQuotingStrategy();
        try {
            targetDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            databaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schemas, targetDatabase, snapshotControl);
            return databaseSnapshot;
        }
        catch (Exception e) {
            throw new CMPException("Unable to create target snapshot", e);
        }
        finally {
            targetDatabase.setObjectQuotingStrategy(originalStrategy);
        }
    }

    private JdbcConnection openConnection(DBRProgressMonitor monitor, CMPInput input, boolean isSource) throws Exception {
        Connection jdbcConnection;
        block14: {
            DBSInstance instance = null;
            for (DBSObject object : input.getInputObjects()) {
                DBSInstance objInstance = DBUtils.getObjectOwnerInstance((DBSObject)object);
                if (instance == null) {
                    instance = objInstance;
                    continue;
                }
                if (instance == objInstance || objInstance == null) continue;
                throw new CMPException("Multiple instances for input source (" + instance.getName() + ", " + objInstance.getName() + ").\nOnly one instance can be used in compare");
            }
            if (!(instance instanceof JDBCRemoteInstance)) {
                throw new CMPException("Only JDBC connections can be used");
            }
            JDBCRemoteInstance remoteInstance = (JDBCRemoteInstance)instance;
            JDBCExecutionContext defaultContext = remoteInstance.getDefaultContext(monitor, false);
            jdbcConnection = null;
            try {
                DBCExecutionContext isolatedContext = remoteInstance.openIsolatedContext(monitor, "Schema comparison", (DBCExecutionContext)defaultContext);
                if (CommonUtils.isEmpty(input.getInputObjects())) break block14;
                DBSObject firstComparedObject = input.getInputObjects().get(0);
                DBSObject dataContainer = this.getTopCatalog(firstComparedObject);
                DBCExecutionContextDefaults contextDefaults = isolatedContext.getContextDefaults();
                try {
                    if (dataContainer != null && contextDefaults != null) {
                        if (contextDefaults.supportsCatalogChange() && dataContainer instanceof DBSCatalog) {
                            DBSSchema schema = null;
                            if (contextDefaults.supportsSchemaChange()) {
                                schema = firstComparedObject instanceof DBSSchema ? (DBSSchema)firstComparedObject : (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)firstComparedObject);
                            }
                            contextDefaults.setDefaultCatalog(monitor, (DBSCatalog)dataContainer, schema);
                        } else if (dataContainer instanceof DBSSchema && contextDefaults.supportsSchemaChange()) {
                            contextDefaults.setDefaultSchema(monitor, (DBSSchema)dataContainer);
                        }
                    }
                    jdbcConnection = ((JDBCExecutionContext)isolatedContext).getConnection(monitor);
                    if (isSource) {
                        this.sourceContext = isolatedContext;
                        break block14;
                    }
                    this.targetContext = isolatedContext;
                }
                catch (DBCException e) {
                    log.debug((Object)"Can't find parent catalog", (Throwable)e);
                }
            }
            catch (DBException e) {
                log.debug((Object)"Can't open isolation context", (Throwable)e);
            }
        }
        if (jdbcConnection == null) {
            throw new Exception("Can't open isolated connection");
        }
        monitor.worked(1);
        return new JdbcConnection(jdbcConnection);
    }

    private Database getDatabase(DBRProgressMonitor monitor, CMPInput input, boolean isSource) throws CMPException {
        try {
            return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)this.openConnection(monitor, input, isSource));
        }
        catch (Exception e1) {
            throw new CMPException("Database unavailable", e1);
        }
    }

    @Override
    public void close() {
        try {
            if (this.sourceContext != null) {
                this.sourceContext.close();
                this.sourceContext = null;
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Can't close source comparison connection", e);
        }
        try {
            if (this.targetContext != null) {
                this.targetContext.close();
                this.targetContext = null;
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Can't close target comparison connection", e);
        }
    }

    @Nullable
    private DBSObject getTopCatalog(DBSObject object) {
        if (object == null) {
            return null;
        }
        DBSObject container = null;
        if (object instanceof DBSObjectContainer) {
            container = object;
        }
        DBSObject parent = object.getParentObject();
        while (parent != null) {
            if (parent instanceof DBPDataSource || parent instanceof DBPDataSourceContainer) break;
            container = parent;
            parent = parent.getParentObject();
        }
        return container;
    }
}

