/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.ui;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudProvider;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.net.auth.iam.AuthModelIAMAbstract;
import com.dbeaver.net.auth.iam.AuthModelIAMCredentials;
import com.dbeaver.ui.auth.iam.AuthModelIAMConfigurator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;
import software.amazon.awssdk.regions.Region;

public class AwsUIConfigurationEditor
implements IObjectPropertyConfigurator<AWSCloudConfiguration> {
    private AuthModelIAMConfigurator iamConfigurator;
    private Tree regionTree;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        TabFolder configTabs = new TabFolder(parent, 0x800080);
        this.createGeneralTab(configTabs, propertyChangeListener);
        this.createRegionsTab(configTabs, propertyChangeListener);
        configTabs.setSelection(0);
    }

    public void createGeneralTab(final TabFolder parent, Runnable propertyChangeListener) {
        Composite topGroup = new Composite((Composite)parent, 0);
        topGroup.setLayout((Layout)new GridLayout(1, false));
        Composite mainGroup = UIUtils.createComposite((Composite)topGroup, (int)2);
        mainGroup.setLayoutData((Object)new GridData(1808));
        this.iamConfigurator = new AuthModelIAMConfigurator();
        this.iamConfigurator.createIAMAuthControls(mainGroup, propertyChangeListener);
        UIUtils.createEmptyLabel((Composite)topGroup, (int)1, (int)1).setLayoutData((Object)new GridData(1808));
        Composite btnComposite = UIUtils.createComposite((Composite)topGroup, (int)2);
        btnComposite.setLayoutData((Object)new GridData(768));
        UIUtils.createEmptyLabel((Composite)btnComposite, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)btnComposite, (String)"Test Cloud Connection", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object context = parent.getShell().getData() instanceof IRunnableContext ? new RunnableContextDelegate((IRunnableContext)parent.getShell().getData()) : UIUtils.getDialogRunnableContext();
                AWSCloudConfiguration cfg = new AWSCloudConfiguration();
                AwsUIConfigurationEditor.this.saveSettings(cfg);
                try {
                    context.run(true, true, monitor -> AwsUIConfigurationEditor.this.testCloudConnection(monitor, cfg));
                }
                catch (InvocationTargetException ex) {
                    DBWorkbench.getPlatformUI().showError("Cloud connect error", "Error during cloud connect", (Throwable)ex);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        TabItem regionsTab = new TabItem(parent, 0);
        regionsTab.setText("Authentication");
        regionsTab.setControl((Control)topGroup);
    }

    private void testCloudConnection(DBRProgressMonitor monitor, AWSCloudConfiguration cfg) throws InvocationTargetException {
        AWSCloud cloud = new AWSCloudProvider().createCloudInstance(cfg);
        try {
            String response = cloud.testConnection(monitor);
            UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)"Success", (String)("Cloud connection established successfully: " + response), (int)2));
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public void createRegionsTab(TabFolder parent, final Runnable propertyChangeListener) {
        Composite regionsGroup = UIUtils.createComposite((Composite)parent, (int)1);
        this.regionTree = new Tree(regionsGroup, 65572);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.regionTree.setLayoutData((Object)gd);
        UIUtils.createTreeColumn((Tree)this.regionTree, (int)16384, (String)"Region ID");
        UIUtils.createTreeColumn((Tree)this.regionTree, (int)16384, (String)"Region Name");
        List allRegions = AWSCloudUtils.getAllRegions(null);
        LinkedHashMap<String, List> regionMap = new LinkedHashMap<String, List>();
        for (Region region : allRegions) {
            List subRegions = regionMap.computeIfAbsent(AWSCloudUtils.getSuperRegion((Region)region), rl -> new ArrayList());
            subRegions.add(region);
        }
        for (String superRegion : regionMap.keySet()) {
            TreeItem srItem = new TreeItem(this.regionTree, 0);
            srItem.setData((Object)superRegion);
            srItem.setText(superRegion);
            for (Region region : (List)regionMap.get(superRegion)) {
                TreeItem rItem = new TreeItem(srItem, 0);
                rItem.setData((Object)region);
                rItem.setText(0, region.id());
                rItem.setText(1, region.metadata().description());
            }
            srItem.setExpanded(true);
        }
        TabItem regionsTab = new TabItem(parent, 0);
        regionsTab.setText("Regions");
        regionsTab.setControl((Control)regionsGroup);
        this.regionTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyChangeListener.run();
            }
        });
        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.packColumns((Tree)AwsUIConfigurationEditor.this.regionTree, (boolean)true, null);
            }
        });
    }

    public void loadSettings(AWSCloudConfiguration configuration) {
        LinkedHashMap authProperties = new LinkedHashMap();
        AuthModelIAMAbstract.saveCredentialsToMap((AuthModelIAMCredentials)configuration.getCredentials(), authProperties);
        this.iamConfigurator.loadIAMAuthSettings(authProperties);
        Object[] defaultRegions = configuration.getDefaultRegions();
        TreeItem[] treeItemArray = this.regionTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem srItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = srItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem rItem = treeItemArray2[n4];
                String regionId = ((Region)rItem.getData()).id();
                rItem.setChecked(ArrayUtils.contains((Object[])defaultRegions, (Object)regionId));
                ++n4;
            }
            ++n2;
        }
    }

    public void saveSettings(AWSCloudConfiguration configuration) {
        LinkedHashMap authProperties = new LinkedHashMap();
        this.iamConfigurator.saveIAMAuthSettings(authProperties);
        AuthModelIAMAbstract.loadCredentialsFromMap((AuthModelIAMCredentials)configuration.getCredentials(), authProperties);
        ArrayList<String> defaultRegions = new ArrayList<String>();
        TreeItem[] treeItemArray = this.regionTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem srItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = srItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem rItem = treeItemArray2[n4];
                if (rItem.getChecked()) {
                    String regionId = ((Region)rItem.getData()).id();
                    defaultRegions.add(regionId);
                }
                ++n4;
            }
            ++n2;
        }
        configuration.setDefaultRegions(defaultRegions.toArray(new String[0]));
    }

    public void resetSettings(AWSCloudConfiguration configuration) {
    }

    public boolean isComplete() {
        return this.iamConfigurator.isComplete();
    }
}

