/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskListener;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIViewMessages;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksTree;
import org.jkiss.dbeaver.tasks.ui.view.TaskHandlerGroupBy;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ILabelProviderEx;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseTasksView
extends ViewPart
implements DBTTaskListener {
    private static final Log log = Log.getLog(DatabaseTasksView.class);
    public static final String VIEW_ID = "org.jkiss.dbeaver.tasks";
    private static final String TASKS_VIEW_MENU_ID = "org.jkiss.dbeaver.tasks.menu";
    public static final String CREATE_TASK_CMD_ID = "org.jkiss.dbeaver.task.create";
    public static final String COPY_TASK_CMD_ID = "org.jkiss.dbeaver.task.copy";
    public static final String EDIT_TASK_CMD_ID = "org.jkiss.dbeaver.task.edit";
    public static final String RUN_TASK_CMD_ID = "org.jkiss.dbeaver.task.run";
    public static final String GROUP_TASK_CMD_ID = "org.jkiss.dbeaver.task.group";
    private static final ArrayList<Object> EMPTY_TASK_RUN_LIST = new ArrayList();
    private DatabaseTasksTree tasksTree;
    private TreeViewer taskRunViewer;
    private ViewerColumnController taskRunColumnController;

    public DatabaseTasksTree getTasksTree() {
        return this.tasksTree;
    }

    public TreeViewer getTaskRunViewer() {
        return this.taskRunViewer;
    }

    public void createPartControl(Composite parent) {
        CustomSashForm sashForm = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)256);
        this.createTaskTree((Composite)sashForm);
        this.createTaskRunTable((Composite)sashForm);
        sashForm.setWeights(new int[]{700, 300});
        this.loadViewConfig();
        this.loadTasks();
    }

    private void createTaskTree(Composite composite) {
        this.tasksTree = new DatabaseTasksTree(composite, false);
        MenuManager menuMgr = this.createTaskContextMenu(this.tasksTree.getViewer());
        this.getSite().registerContextMenu(TASKS_VIEW_MENU_ID, menuMgr, (ISelectionProvider)this.tasksTree.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tasksTree.getViewer());
        this.tasksTree.getViewer().addDoubleClickListener(event -> ActionUtils.runCommand((String)EDIT_TASK_CMD_ID, (ISelection)this.getSite().getSelectionProvider().getSelection(), (IServiceLocator)this.getSite()));
        this.tasksTree.getViewer().addSelectionChangedListener(event -> this.loadTaskRuns());
        DatabaseTasksTree.addDragSourceSupport((Viewer)this.tasksTree.getViewer(), null);
    }

    private void createTaskRunTable(Composite parent) {
        this.taskRunViewer = DialogUtils.createFilteredTree((Composite)parent, (int)65540, (PatternFilter)new NamedObjectPatternFilter(), (String)TaskUIViewMessages.db_tasks_view_filtered_tree_text_error_message);
        Tree taskrunTree = this.taskRunViewer.getTree();
        taskrunTree.setHeaderVisible(true);
        taskrunTree.setLayoutData((Object)new GridData(1808));
        this.taskRunColumnController = new ViewerColumnController("taskruns", (ColumnViewer)this.taskRunViewer);
        this.taskRunColumnController.addColumn(TaskUIViewMessages.db_tasks_view_column_controller_add_name_time, TaskUIViewMessages.db_tasks_view_column_controller_add_descr_start_time, 16384, true, true, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                cell.setText(tasksTree.getDateFormat().format(taskRun.getStartTime()));
            }
        });
        this.taskRunColumnController.addColumn(TaskUIViewMessages.db_tasks_view_column_controller_add_name_duration, TaskUIViewMessages.db_tasks_view_column_controller_add_descr_task_duration, 16384, true, false, true, null, (CellLabelProvider)new TaskRunLabelProviderEx(this){

            public String getText(Object element, boolean forUI) {
                DBTTaskRun taskRun = (DBTTaskRun)element;
                return forUI ? RuntimeUtils.formatExecutionTime((long)taskRun.getRunDuration()) : String.valueOf(taskRun.getRunDuration());
            }

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                cell.setText(RuntimeUtils.formatExecutionTime((long)taskRun.getRunDuration()));
            }
        }, null);
        this.taskRunColumnController.addColumn(TaskUIViewMessages.db_tasks_view_column_controller_add_name_result, TaskUIViewMessages.db_tasks_view_column_controller_add_descr_task_result, 16384, true, false, (CellLabelProvider)new TaskRunLabelProvider(this){

            @Override
            protected void update(ViewerCell cell, DBTTaskRun taskRun) {
                if (taskRun.isRunSuccess()) {
                    cell.setText(TaskUIViewMessages.db_tasks_view_cell_text_success);
                } else {
                    cell.setText(CommonUtils.notEmpty((String)taskRun.getErrorMessage()));
                }
            }
        });
        this.taskRunColumnController.setForceAutoSize(true);
        this.taskRunColumnController.createColumns(true);
        this.taskRunViewer.setContentProvider((IContentProvider)new TreeRunContentProvider());
        MenuManager menuMgr = this.createTaskRunContextMenu(this.taskRunViewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.taskRunViewer);
        this.taskRunViewer.addDoubleClickListener(event -> new ViewRunLogAction().run());
    }

    private MenuManager createTaskContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)RUN_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)EDIT_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)CREATE_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)COPY_TASK_CMD_ID));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.eclipse.ui.edit.delete", (String)TaskUIViewMessages.db_tasks_view_context_menu_command_delete_task, null));
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
            TaskHandlerGroupBy.GroupBy[] groupByArray = TaskHandlerGroupBy.GroupBy.values();
            int n = groupByArray.length;
            int n2 = 0;
            while (n2 < n) {
                TaskHandlerGroupBy.GroupBy gb = groupByArray[n2];
                manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)GROUP_TASK_CMD_ID, (int)32, null, null, null, (boolean)true, Collections.singletonMap("group", gb.name())));
                ++n2;
            }
            manager.add((IContributionItem)new Separator());
            this.tasksTree.getColumnController().fillConfigMenu((IContributionManager)manager);
        });
        Control control = viewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        return menuMgr;
    }

    private MenuManager createTaskRunContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> {
            DBTTask task = this.tasksTree.getSelectedTask();
            DBTTaskRun taskRun = this.getSelectedTaskRun();
            if (task != null && taskRun != null) {
                manager.add((IAction)new ViewRunLogAction());
                manager.add((IAction)new DeleteRunLogAction());
            }
            if (task != null && task.getLastRun() != null) {
                manager.add((IAction)new ClearRunLogAction());
                manager.add((IAction)new OpenRunLogFolderAction());
            }
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IContributionItem)new Separator());
            this.taskRunColumnController.fillConfigMenu((IContributionManager)manager);
        });
        Control control = viewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        return menuMgr;
    }

    public void setFocus() {
        this.tasksTree.getViewer().getControl().setFocus();
    }

    @Nullable
    private DBTTaskRun getSelectedTaskRun() {
        ISelection selection = this.taskRunViewer.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        return element instanceof DBTTaskRun ? (DBTTaskRun)element : null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast(new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return TaskUIViewMessages.db_tasks_view_adapter_label_database_tasks;
                }
            });
        }
        return (T)super.getAdapter(adapter);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        TaskRegistry.getInstance().addTaskListener((DBTTaskListener)this);
    }

    public void dispose() {
        TaskRegistry.getInstance().removeTaskListener((DBTTaskListener)this);
        super.dispose();
    }

    public void handleTaskEvent(DBTTaskEvent event) {
        UIUtils.asyncExec(() -> {
            DBTTask task = event.getTask();
            switch (event.getAction()) {
                case TASK_ADD: {
                    this.refresh();
                    this.tasksTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)task), true);
                    break;
                }
                case TASK_REMOVE: {
                    this.refresh();
                    break;
                }
                case TASK_UPDATE: {
                    this.tasksTree.getViewer().refresh((Object)task);
                    if (task != this.tasksTree.getSelectedTask()) break;
                    this.loadTaskRuns();
                    break;
                }
                case TASK_EXECUTE: {
                    this.refresh();
                }
            }
        });
    }

    private void loadViewConfig() {
        this.tasksTree.loadViewConfig();
    }

    public void refresh() {
        this.tasksTree.refresh();
        this.loadTaskRuns();
    }

    private void loadTasks() {
        this.tasksTree.loadTasks();
    }

    private void loadTaskRuns() {
        DBTTask selectedTask = this.tasksTree.getSelectedTask();
        if (selectedTask == null) {
            this.taskRunViewer.setInput(EMPTY_TASK_RUN_LIST);
        } else {
            Object[] runs = selectedTask.getRunStatistics();
            if (ArrayUtils.isEmpty((Object[])runs)) {
                this.taskRunViewer.setInput(EMPTY_TASK_RUN_LIST);
            } else {
                Arrays.sort(runs, Comparator.comparing(DBTTaskRun::getStartTime).reversed());
                this.taskRunViewer.setInput(Arrays.asList(runs));
            }
        }
    }

    private class ClearRunLogAction
    extends Action {
        ClearRunLogAction() {
            super(TaskUIViewMessages.db_tasks_view_clear_run_log_clear, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ERASE));
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.tasksTree.getSelectedTask();
            if (task == null || !UIUtils.confirmAction((String)TaskUIViewMessages.db_tasks_view_clear_run_log_confirm_clear, (String)NLS.bind((String)TaskUIViewMessages.db_tasks_view_clear_run_log_confirm_delete_log, (Object)task.getName()))) {
                return;
            }
            task.cleanRunStatistics();
        }
    }

    private class DeleteRunLogAction
    extends Action {
        DeleteRunLogAction() {
            super(TaskUIViewMessages.db_tasks_view_run_log_delete, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE));
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.tasksTree.getSelectedTask();
            DBTTaskRun taskRun = DatabaseTasksView.this.getSelectedTaskRun();
            if (task != null && taskRun != null && UIUtils.confirmAction((String)TaskUIViewMessages.db_tasks_view_run_log_confirm_remove, (String)NLS.bind((String)TaskUIViewMessages.db_tasks_view_run_log_confirm_delete_task, (Object)task.getName(), (Object)DatabaseTasksView.this.tasksTree.getDateFormat().format(taskRun.getStartTime())))) {
                task.removeRunLog(taskRun);
            }
        }
    }

    public class NamedObjectPatternFilter
    extends PatternFilter {
        NamedObjectPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof DBTTask) {
                return this.wordMatches(((DBTTask)element).getName());
            }
            if (element instanceof DBTTaskRun) {
                return this.wordMatches(element.toString());
            }
            return true;
        }
    }

    private class OpenRunLogFolderAction
    extends Action {
        OpenRunLogFolderAction() {
            super(TaskUIViewMessages.db_tasks_view_open_run_log_folder_open);
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.tasksTree.getSelectedTask();
            if (task != null) {
                DBWorkbench.getPlatformUI().executeShellProgram(task.getRunLogFolder().getAbsolutePath());
            }
        }
    }

    private static class TaskCategoryNode {
        final DBPProject project;
        final TaskCategoryNode parent;
        final DBTTaskCategory category;

        TaskCategoryNode(DBPProject project, TaskCategoryNode parent, DBTTaskCategory category) {
            this.project = project;
            this.parent = parent;
            this.category = category;
        }

        public String toString() {
            return this.category.getName();
        }

        public int hashCode() {
            return (this.project == null ? 0 : this.project.hashCode()) + (this.parent == null ? 0 : this.parent.hashCode()) + (this.category == null ? 0 : this.category.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskCategoryNode)) {
                return false;
            }
            TaskCategoryNode cmp = (TaskCategoryNode)obj;
            return this.project == cmp.project && CommonUtils.equalObjects((Object)this.parent, (Object)cmp.parent) && this.category == cmp.category;
        }
    }

    private abstract class TaskRunLabelProvider
    extends ColumnLabelProvider {
        private TaskRunLabelProvider() {
        }

        public final void update(ViewerCell cell) {
            DBTTaskRun taskRun = (DBTTaskRun)cell.getElement();
            if (taskRun != null && !taskRun.isRunSuccess()) {
                cell.setBackground(DatabaseTasksView.this.tasksTree.getColorError());
            } else {
                cell.setBackground(null);
            }
            this.update(cell, taskRun);
        }

        protected abstract void update(ViewerCell var1, DBTTaskRun var2);
    }

    private abstract class TaskRunLabelProviderEx
    extends TaskRunLabelProvider
    implements ILabelProviderEx {
        private TaskRunLabelProviderEx() {
        }
    }

    private class TreeRunContentProvider
    implements ITreeContentProvider {
        private TreeRunContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class ViewRunLogAction
    extends Action {
        ViewRunLogAction() {
            super(TaskUIViewMessages.db_tasks_view_run_log_view);
        }

        public void run() {
            DBTTask task = DatabaseTasksView.this.tasksTree.getSelectedTask();
            DBTTaskRun taskRun = DatabaseTasksView.this.getSelectedTaskRun();
            if (task != null && taskRun != null) {
                File runLog = task.getRunLog(taskRun);
                if (runLog.exists()) {
                    try {
                        IDocumentProvider prov;
                        IEditorPart editorPart = EditorUtils.openExternalFileEditor((File)runLog, (IWorkbenchWindow)DatabaseTasksView.this.getSite().getWorkbenchWindow());
                        if (editorPart instanceof ITextEditor && (prov = ((ITextEditor)editorPart).getDocumentProvider()) instanceof TextFileDocumentProvider) {
                            ((TextFileDocumentProvider)prov).setEncoding((Object)editorPart.getEditorInput(), StandardCharsets.UTF_8.name());
                            prov.resetDocument((Object)editorPart.getEditorInput());
                        }
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Open log error", "Error while opening task execution log", (Throwable)e);
                    }
                } else {
                    UIUtils.showMessageBox((Shell)DatabaseTasksView.this.getSite().getShell(), (String)"Lof file not found", (String)("Can't find log file '" + runLog.getAbsolutePath() + "'"), (int)1);
                }
            }
        }
    }
}

