/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AzureCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_IDP_TENANT = "idp_tenant";
    private static final String KEY_CLIENT_SECRET = "client_secret";
    private static final String KEY_CLIENT_ID = "client_id";
    private String m_idpTenant;
    private String m_clientSecret;
    private String m_clientId;

    @Override
    protected String getSamlAssertion() throws IOException {
        if (StringUtils.isNullOrEmpty(this.m_idpTenant)) {
            throw new IOException("Missing required property: idp_tenant");
        }
        if (StringUtils.isNullOrEmpty(this.m_userName)) {
            throw new IOException("Missing required property: UID or user");
        }
        if (StringUtils.isNullOrEmpty(this.m_password)) {
            throw new IOException("Missing required property: PWD or password");
        }
        if (StringUtils.isNullOrEmpty(this.m_clientSecret)) {
            throw new IOException("Missing required property: client_secret");
        }
        if (StringUtils.isNullOrEmpty(this.m_clientId)) {
            throw new IOException("Missing required property: client_id");
        }
        return this.azureOauthBasedAuthentication();
    }

    @Override
    public void addParameter(String string, String string2) {
        if (KEY_IDP_TENANT.equalsIgnoreCase(string)) {
            this.m_idpTenant = string2;
        } else if (KEY_CLIENT_SECRET.equalsIgnoreCase(string)) {
            this.m_clientSecret = string2;
        } else if (KEY_CLIENT_ID.equalsIgnoreCase(string)) {
            this.m_clientId = string2;
        } else {
            super.addParameter(string, string2);
        }
    }

    private String azureOauthBasedAuthentication() throws IOException, SdkClientException {
        String string;
        String string2 = "https://login.microsoftonline.com/" + this.m_idpTenant + "/oauth2/token";
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            String string3;
            closeableHttpClient = this.getHttpClient();
            HttpPost httpPost = new HttpPost(string2);
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(7);
            arrayList.add(new BasicNameValuePair("grant_type", "password"));
            arrayList.add(new BasicNameValuePair("requested_token_type", "urn:ietf:params:oauth:token-type:saml2"));
            arrayList.add(new BasicNameValuePair("username", this.m_userName));
            arrayList.add(new BasicNameValuePair("password", this.m_password));
            arrayList.add(new BasicNameValuePair(KEY_CLIENT_SECRET, this.m_clientSecret));
            arrayList.add(new BasicNameValuePair(KEY_CLIENT_ID, this.m_clientId));
            arrayList.add(new BasicNameValuePair("resource", this.m_clientId));
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.addHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList, Charset.forName("UTF-8")));
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            String string4 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            JsonNode jsonNode = Jackson.jsonNodeOf(string4);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                String string5 = "Authentication failed on the Azure server. Please check the tenant, user, password, client secret, and client id.";
                JsonNode jsonNode2 = jsonNode.findValue("error_description");
                if (jsonNode2 != null && !StringUtils.isNullOrEmpty(jsonNode2.textValue())) {
                    String string6 = jsonNode2.textValue().replaceAll("\r\n", " ");
                    JsonNode jsonNode3 = jsonNode.findValue("error");
                    string5 = jsonNode3 != null && !StringUtils.isNullOrEmpty(jsonNode3.textValue()) ? jsonNode3.textValue() + ": " + string6 : "Unexpected response: " + string6;
                }
                throw new IOException(string5);
            }
            JsonNode jsonNode4 = jsonNode.findValue("access_token");
            if (jsonNode4 != null) {
                string3 = jsonNode4.textValue();
                if (StringUtils.isNullOrEmpty(string3)) {
                    throw new IOException("Invalid Azure access_token response");
                }
            } else {
                throw new IOException("Failed to find Azure access_token");
            }
            String string7 = new String(Base64.decodeBase64((String)string3), Charset.forName("UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\">");
            stringBuilder.append("<samlp:Status>");
            stringBuilder.append("<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/>");
            stringBuilder.append("</samlp:Status>");
            stringBuilder.append(string7);
            stringBuilder.append("</samlp:Response>");
            string = new String(Base64.encodeBase64((byte[])stringBuilder.toString().getBytes()));
        }
        catch (GeneralSecurityException generalSecurityException) {
            try {
                throw new SdkClientException("Failed to create SSLContext", generalSecurityException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(closeableHttpResponse, null);
                IOUtils.closeQuietly((Closeable)closeableHttpClient, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)closeableHttpResponse, null);
        IOUtils.closeQuietly((Closeable)closeableHttpClient, null);
        return string;
    }
}

