/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.ui.views;

import com.dbeaver.db.dynamodb.model.DynamoServerType;
import com.dbeaver.db.dynamodb.ui.DynamoDBMessages;
import com.dbeaver.db.dynamodb.ui.DynamoDBUIActivator;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class DynamoDBConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static ImageDescriptor logoImage = DynamoDBUIActivator.getImageDescriptor("icons/dynamodb_logo.png");
    private Composite settingsGroup;
    private Combo regionCombo;
    private boolean activated;
    private Text endpointText;
    private DynamoServerType serverType = DynamoServerType.AWS;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite group = new Composite(composite, 0);
        group.setLayoutData((Object)new GridData(1808));
        group.setLayout((Layout)new GridLayout(1, true));
        this.createGeneralTab(group);
        this.createDriverPanel(group);
        this.setControl((Control)group);
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        this.settingsGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        this.settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.settingsGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)this.settingsGroup, (String)DynamoDBMessages.connection_page_control_group_server, (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)serverGroup, (String)"Type");
        Composite typePanel = UIUtils.createComposite((Composite)serverGroup, (int)2);
        SelectionAdapter serverTypeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamoDBConnectionPage.this.serverType = (DynamoServerType)e.widget.getData();
                DynamoDBConnectionPage.this.endpointText.setEnabled(DynamoDBConnectionPage.this.serverType == DynamoServerType.STANDALONE);
                if (DynamoDBConnectionPage.this.activated) {
                    DynamoDBConnectionPage.this.saveAndUpdate();
                }
            }
        };
        Button conTypeAWSRadio = UIUtils.createRadioButton((Composite)typePanel, (String)"AWS", (Object)DynamoServerType.AWS, (SelectionListener)serverTypeListener);
        Button conTypeStandaloneRadio = UIUtils.createRadioButton((Composite)typePanel, (String)"Standalone", (Object)DynamoServerType.STANDALONE, (SelectionListener)serverTypeListener);
        if (this.serverType == DynamoServerType.AWS) {
            conTypeAWSRadio.setSelection(true);
        } else {
            conTypeStandaloneRadio.setSelection(true);
        }
        this.regionCombo = UIUtils.createLabelCombo((Composite)serverGroup, (String)"AWS Region", (int)2052);
        this.regionCombo.setLayoutData((Object)new GridData(32));
        this.regionCombo.addModifyListener(textListener);
        for (Region region : Region.regions()) {
            this.regionCombo.add(region.id());
        }
        this.regionCombo.setText(Region.US_EAST_1.id());
        this.endpointText = UIUtils.createLabelText((Composite)serverGroup, (String)"Endpoint", (String)"", (int)2048);
        this.endpointText.setLayoutData((Object)new GridData(768));
        this.endpointText.addModifyListener(textListener);
        this.endpointText.setText("http://localhost:8000");
        this.createAuthPanel(this.settingsGroup, 2);
        return this.settingsGroup;
    }

    public boolean isComplete() {
        if (this.regionCombo == null) {
            return false;
        }
        if (this.regionCombo.getText().isEmpty()) {
            return false;
        }
        if (this.serverType == DynamoServerType.STANDALONE) {
            return !this.endpointText.getText().isEmpty();
        }
        return super.isComplete();
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        String serverTypeStr = connectionInfo.getProviderProperty("serverType");
        this.serverType = (DynamoServerType)CommonUtils.valueOf(DynamoServerType.class, (String)serverTypeStr, (Enum)DynamoServerType.AWS);
        String regionName = connectionInfo.getProviderProperty("regionName");
        if (!CommonUtils.isEmpty((String)regionName)) {
            this.regionCombo.setText(regionName);
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
            this.endpointText.setText(connectionInfo.getHostName());
        }
        this.endpointText.setEnabled(this.serverType == DynamoServerType.STANDALONE);
        super.loadSettings();
        this.activated = true;
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "iam_simple";
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setProviderProperty("serverType", this.serverType.name());
        connectionInfo.setProviderProperty("regionName", this.regionCombo.getText());
        if (this.serverType == DynamoServerType.STANDALONE) {
            connectionInfo.setHostName(this.endpointText.getText().trim());
        } else {
            connectionInfo.setHostName(null);
        }
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[0];
    }
}

