/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.snowflake.snapshot;

import java.util.Locale;
import liquibase.database.Database;
import liquibase.ext.snowflake.database.SnowflakeDatabase;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.jvm.SequenceSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class SnowflakeSequenceSnapshotGenerator
extends SequenceSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof SnowflakeDatabase) {
            int priority = super.getPriority(objectType, database);
            return priority += 5;
        }
        return -1;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{SequenceSnapshotGenerator.class};
    }

    protected String getSelectSequenceSql(Schema schema, Database database) {
        if (database instanceof SnowflakeDatabase) {
            return "SELECT\nSEQUENCE_NAME,\nSTART_VALUE,\n\"INCREMENT\" AS INCREMENT_BY,\nCYCLE_OPTION AS WILL_CYCLE\nFROM\n\"" + schema.getCatalogName().toUpperCase(Locale.ENGLISH) + "\".INFORMATION_SCHEMA.\"SEQUENCES\" s\nWHERE\ns.SEQUENCE_SCHEMA ='" + schema.getName() + "'";
        }
        return super.getSelectSequenceSql(schema, database);
    }
}

