/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.exec.RedisBaseResultSet;
import com.dbeaver.db.redis.exec.RedisBaseStatement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;

public class RedisResultSetSimple
extends RedisBaseResultSet {
    private static final Log log = Log.getLog(RedisResultSetSimple.class);
    private final Object resultSet;
    private final List<Object> outputLines = new ArrayList<Object>();
    private final RedisBaseResultSet.OutputAttribute outputAttribute = new RedisBaseResultSet.OutputAttribute("output", 0, 1, DBPDataKind.STRING);

    public RedisResultSetSimple(RedisBaseStatement statement, Object resultSet, long offset) {
        super(statement);
        this.resultSet = resultSet;
        if (offset > 0L) {
            this.rowNumber = (int)(offset - 1L);
        }
        if (resultSet instanceof String) {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (BufferedReader in = new BufferedReader(new StringReader((String)resultSet));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        this.outputLines.add(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        } else if (resultSet instanceof Collection) {
            this.outputLines.addAll((Collection)resultSet);
        } else if (resultSet instanceof Map) {
            this.outputLines.addAll(((Map)resultSet).entrySet());
        } else if (resultSet != null) {
            this.outputLines.add(resultSet);
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        if (this.rowNumber < 0) {
            throw new DBCException("Raw wasn't fetched");
        }
        if (this.rowNumber >= this.outputLines.size()) {
            throw new DBCException("Out of data");
        }
        Object rowValue = this.outputLines.get(this.rowNumber);
        if (rowValue instanceof Map.Entry) {
            if (index == 0) {
                return ((Map.Entry)rowValue).getKey();
            }
            if (index == 1) {
                return ((Map.Entry)rowValue).getValue();
            }
            throw new DBCException("Index " + index + " out of range (<=1)");
        }
        if (index > 0) {
            throw new DBCException("Index " + index + " out of range (<=0)");
        }
        return rowValue;
    }

    public Object getAttributeValue(String name) throws DBCException {
        if (name.equals("output") || name.equals("name")) {
            return this.getAttributeValue(0);
        }
        if (name.equals("value")) {
            return this.getAttributeValue(1);
        }
        throw new DBCException("Attribute '" + name + "' not supported");
    }

    public boolean nextRow() throws DBCException {
        if (this.rowNumber >= this.outputLines.size()) {
            return false;
        }
        ++this.rowNumber;
        return this.rowNumber < this.outputLines.size();
    }

    public boolean moveTo(int position) throws DBCException {
        if (position < -1 || position > this.outputLines.size()) {
            return false;
        }
        this.rowNumber = position;
        return true;
    }

    @Override
    protected void fillMetaData(List<DBCAttributeMetaData> attributes) {
        if (this.resultSet instanceof Map) {
            attributes.add(new RedisBaseResultSet.OutputAttribute("name", 0, 1, DBPDataKind.OBJECT));
            attributes.add(new RedisBaseResultSet.OutputAttribute("value", 1, 1, DBPDataKind.OBJECT));
        } else {
            attributes.add(this.outputAttribute);
        }
    }
}

