/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.ui.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorTrustStoreUI;
import org.jkiss.utils.CommonUtils;

public class CasSSLConfigurator
extends SSLConfiguratorTrustStoreUI {
    private TextWithOpen trustStorePath;
    private Text trustStorePassword;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createSSLConfigHint(composite, true, 1);
        Group certGroup = UIUtils.createControlGroup((Composite)composite, (String)"Trust Store", (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)certGroup, (String)"Client Trust Store");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.trustStorePath = new TextWithOpenFile((Composite)certGroup, "Client Trust Store", new String[]{"*.*", "*.jks", "*"});
        this.trustStorePath.setLayoutData((Object)new GridData(768));
        this.trustStorePassword = UIUtils.createLabelText((Composite)certGroup, (String)"Trust Store password", (String)"", (int)0x400800);
        gd = new GridData(32);
        gd.widthHint = 130;
        this.trustStorePassword.setLayoutData((Object)gd);
        UIUtils.createInfoLabel((Composite)certGroup, (String)"Trust store file must be in Java KeyStore format (jks)", (int)768, (int)2);
        certGroup = this.createTrustStoreConfigGroup(composite);
        UIUtils.createInfoLabel((Composite)certGroup, (String)"Use it if you have client certificate and private key", (int)768, (int)2);
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        this.trustStorePath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.trustStore")));
        this.trustStorePassword.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.trustStorePassword")));
        super.loadSettings(configuration);
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.setProperty("ssl.trustStore", (Object)this.trustStorePath.getText());
        configuration.setProperty("ssl.trustStorePassword", (Object)this.trustStorePassword.getText());
        super.saveSettings(configuration);
    }
}

