/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.redshift;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.Endpoint;

public class AWSCloudRedshiftCluster
extends AWSCloudAbstractInstance {
    private final Cluster cluster;

    public AWSCloudRedshiftCluster(AWSCloudSession session, AWSCloudZone zone, Cluster cluster) {
        super(session, zone);
        this.cluster = cluster;
    }

    @NotNull
    public String getInstanceId() {
        return this.cluster.clusterIdentifier();
    }

    @NotNull
    public String getInstanceName() {
        return this.cluster.dbName();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.cluster.endpoint().address();
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setDatabaseName(this.cluster.dbName());
        Endpoint endpoint = this.cluster.endpoint();
        if (endpoint != null) {
            configuration.setHostName(endpoint.address());
            configuration.setHostPort(CommonUtils.toString((Object)endpoint.port()));
        }
        configuration.setUserName(this.getInstanceUserName());
        configuration.setAuthModelId("redshift_iam");
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.REDSHIFT;
    }

    @Override
    protected String getInstanceUserName() {
        String userName = super.getInstanceUserName();
        return userName != null ? userName : this.cluster.masterUsername();
    }

    @Override
    protected String getInstanceARN() {
        return this.cluster.clusterIdentifier();
    }

    @Override
    protected String getExternalLink() {
        return String.valueOf(this.getLinkPrefix()) + "cluster-details?cluster=" + this.cluster.clusterIdentifier();
    }

    @Property(viewable=true, order=40)
    @NotNull
    public String getRedshiftClusterIdentifier() {
        return this.cluster.clusterIdentifier();
    }

    @Property(viewable=true, order=41)
    @NotNull
    public String getRedshiftClusterStatus() {
        return this.cluster.clusterStatus();
    }

    @Property(viewable=true, order=42)
    @NotNull
    public String getRedshiftClusterAvailabilityStatus() {
        return this.cluster.clusterAvailabilityStatus();
    }

    @Property(viewable=true, order=50)
    @NotNull
    public String getRedshiftNodeType() {
        return this.cluster.nodeType();
    }
}

