/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.rds;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.aws.AWSDatabaseEngine;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.runtime.net.DefaultCallbackHandler;

public abstract class AWSCloudRdsBaseInstance
extends AWSCloudAbstractInstance {
    protected AWSCloudRdsBaseInstance(AWSCloudSession session, AWSCloudZone zone) {
        super(session, zone);
    }

    @Override
    protected boolean isDriverNeedsAuthentication() {
        return true;
    }

    protected void setDefaultDataSourceConfiguration(AWSDatabaseEngine instanceFamily, DBPConnectionConfiguration configuration) throws DBException {
        switch (instanceFamily) {
            case AURORA_POSTGRESQL: 
            case POSTGRES: {
                configuration.setAuthModelId("iam");
                configuration.setProperty("ssl", "true");
                configuration.setProperty("sslmode", "require");
                configuration.setProperty("sslpasswordcallback", DefaultCallbackHandler.class.getName());
                break;
            }
            case AURORA: 
            case AURORA_MYSQL: 
            case MYSQL: {
                configuration.setAuthModelId("iam");
                configuration.setProperty("useSSL", "true");
                configuration.setProperty("requireSSL", "true");
                break;
            }
            case MARIADB: {
                configuration.setAuthModelId("native");
                configuration.setProperty("useSSL", "false");
                break;
            }
            case ORACLE_SE: 
            case ORACLE_SE1: 
            case ORACLE_SE2: 
            case ORACLE_EE: {
                configuration.setAuthModelId("oracle_native");
                break;
            }
            case SQLSERVER_SE: 
            case SQLSERVER_EE: 
            case SQLSERVER_EX: {
                configuration.setAuthModelId("native");
                break;
            }
            case DOCDB: {
                break;
            }
            default: {
                throw new DBException("RDS engine '" + (Object)((Object)instanceFamily) + "' not supported");
            }
        }
    }

    public String toString() {
        return this.getAwsResourceARN();
    }
}

