/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.athena;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.utils.CommonUtils;

public class AWSCloudAthenaEndpoint
extends AWSCloudAbstractInstance {
    private String accountId;

    public AWSCloudAthenaEndpoint(AWSCloudSession session, AWSCloudZone region, String accountId) {
        super(session, region);
        this.accountId = accountId;
    }

    @NotNull
    public String getInstanceId() {
        return this.getAwsRegionId();
    }

    @NotNull
    public String getInstanceName() {
        return this.getZone().getName();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return "athena." + this.getAwsRegionId() + ".amazonaws.com:" + this.getAthenaPortNumber();
    }

    public int getAthenaPortNumber() {
        int defPort = 443;
        try {
            defPort = CommonUtils.toInt((Object)AWSCloudService.ATHENA.getInstanceDriver().getDefaultPort());
        }
        catch (DBException dBException) {}
        return defPort;
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setServerName(this.getAwsRegionId());
        configuration.setDatabaseName("s3://aws-athena-query-results-" + this.accountId + "-" + this.getAwsRegionId());
        configuration.setHostName(null);
        configuration.setHostPort(String.valueOf(this.getAthenaPortNumber()));
        configuration.setAuthModelId("iam_simple");
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.ATHENA;
    }

    @Override
    protected String getInstanceARN() {
        return "arn:aws:athena:" + this.getAwsRegionId();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix();
    }
}

