/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import software.amazon.awssdk.regions.Region;

public class AWSCloudUtils {
    private static final Log log = Log.getLog(AWSCloudUtils.class);
    private static final String SR_NORTH_AMERICA = "North America";
    private static final String SR_SOUTH_AMERICA = "South America";
    private static final String SR_EUROPE = "Europe";
    private static final String SR_ASIA = "Asia";
    private static final String SR_AFRICA = "Africa";

    public static CPCloud<?, ?>[] getAllClouds() {
        List providers = CloudProviderRegistry.getInstance().getCloudProviders();
        ArrayList clouds = new ArrayList();
        for (CloudProviderDescriptor cpDescriptor : providers) {
            Collections.addAll(clouds, cpDescriptor.getInstance().getAvailableClouds());
        }
        return clouds.toArray(new CPCloud[0]);
    }

    public static CPCloud<?, ?> getCloud(String cloudId) {
        List providers = CloudProviderRegistry.getInstance().getCloudProviders();
        for (CloudProviderDescriptor cpDescriptor : providers) {
            CPCloud[] cPCloudArray = cpDescriptor.getInstance().getAvailableClouds();
            int n = cPCloudArray.length;
            int n2 = 0;
            while (n2 < n) {
                CPCloud cloud = cPCloudArray[n2];
                if (cloud.getCloudId().equals(cloudId)) {
                    return cloud;
                }
                ++n2;
            }
        }
        return null;
    }

    public static CPCloud<?, ?> getCloud(CloudProviderDescriptor provider, String cloudId) {
        if (provider != null) {
            CPCloud[] cPCloudArray = provider.getInstance().getAvailableClouds();
            int n = cPCloudArray.length;
            int n2 = 0;
            while (n2 < n) {
                CPCloud cloud = cPCloudArray[n2];
                if (cloud.getCloudId().equals(cloudId)) {
                    return cloud;
                }
                ++n2;
            }
        }
        return null;
    }

    public static <T extends CPCloudConfiguration> T getCloudConfiguration(String cloudId, Class<T> configurationType) {
        CPCloud<?, ?> cloud = AWSCloudUtils.getCloud(cloudId);
        if (cloud != null) {
            return (T)((CPCloudConfiguration)configurationType.cast(cloud.getCloudConfiguration()));
        }
        return null;
    }

    @Nullable
    public static AWSCloudConfiguration getAwsCloudConfiguration() {
        return (AWSCloudConfiguration)CPCloudUtils.getCloudConfiguration((String)"AWS", AWSCloudConfiguration.class);
    }

    public static CloudProviderDescriptor getAwsCloudProvider() {
        return CloudProviderRegistry.getInstance().getCloudProvider("aws");
    }

    public static List<Region> getAllRegions(AWSCloudConfiguration awsConfig) {
        ArrayList<Region> allRegions = new ArrayList<Region>();
        for (Region region : Region.regions()) {
            if (region.isGlobalRegion() || region.id().contains("-iso") && (awsConfig == null || !awsConfig.isIsoRegionsEnabled()) || region.id().contains("-gov") && (awsConfig == null || !awsConfig.isGovRegionsEnabled())) continue;
            allRegions.add(region);
        }
        allRegions.sort((o1, o2) -> {
            if (o1.id().startsWith("us-") && !o2.id().startsWith("us-")) {
                return -1;
            }
            if (o2.id().startsWith("us-") && !o1.id().startsWith("us-")) {
                return 1;
            }
            return o1.id().compareTo(o2.id());
        });
        return allRegions;
    }

    public static String getSuperRegion(Region region) {
        String srId;
        int divPos = region.id().indexOf(45);
        String string = srId = divPos < 0 ? null : region.id().substring(0, divPos);
        if (srId == null) {
            return null;
        }
        switch (srId) {
            case "ca": 
            case "us": {
                return SR_NORTH_AMERICA;
            }
            case "sa": {
                return SR_SOUTH_AMERICA;
            }
            case "eu": {
                return SR_EUROPE;
            }
            case "ap": 
            case "cn": 
            case "me": {
                return SR_ASIA;
            }
            case "af": {
                return SR_AFRICA;
            }
        }
        return srId;
    }
}

